/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.opensimplex;

import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex2DVariant;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex3DVariant;
import de.articdive.jnoise.generators.noise_parameters.simplex_variants.Simplex4DVariant;
import de.articdive.jnoise.generators.noisegen.opensimplex.OpenSimplex2S;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class SuperSimplexNoiseGenerator
implements SeededNoiseGenerator {
    private final long seed;
    private final Simplex2DVariant variant2D;
    private final Simplex3DVariant variant3D;
    private final Simplex4DVariant variant4D;

    private SuperSimplexNoiseGenerator(long seed, Simplex2DVariant variant2D, Simplex3DVariant variant3D, Simplex4DVariant variant4D) {
        this.seed = seed;
        this.variant2D = variant2D;
        this.variant3D = variant3D;
        this.variant4D = variant4D;
    }

    public double evaluateNoise(double x, long seed) {
        return OpenSimplex2S.noise2(seed, x, 1.0);
    }

    public double evaluateNoise(double x, double y, long seed) {
        return switch (this.variant2D) {
            default -> throw new IncompatibleClassChangeError();
            case Simplex2DVariant.IMPROVE_X -> OpenSimplex2S.noise2_ImproveX(seed, x, y);
            case Simplex2DVariant.CLASSIC -> OpenSimplex2S.noise2(seed, x, y);
        };
    }

    public double evaluateNoise(double x, double y, double z, long seed) {
        return switch (this.variant3D) {
            default -> throw new IncompatibleClassChangeError();
            case Simplex3DVariant.IMPROVE_XY -> OpenSimplex2S.noise3_ImproveXY(seed, x, y, z);
            case Simplex3DVariant.IMPROVE_XZ -> OpenSimplex2S.noise3_ImproveXZ(seed, x, y, z);
            case Simplex3DVariant.CLASSIC -> OpenSimplex2S.noise3_Fallback(seed, x, y, z);
        };
    }

    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        return switch (this.variant4D) {
            default -> throw new IncompatibleClassChangeError();
            case Simplex4DVariant.IMPROVE_XY_IMPROVE_ZW -> OpenSimplex2S.noise4_ImproveXY_ImproveZW(seed, x, y, z, w);
            case Simplex4DVariant.IMPROVE_XYZ_IMPROVE_XY -> OpenSimplex2S.noise4_ImproveXYZ_ImproveXY(seed, x, y, z, w);
            case Simplex4DVariant.IMPROVE_XYZ_IMPROVE_XZ -> OpenSimplex2S.noise4_ImproveXYZ_ImproveXZ(seed, x, y, z, w);
            case Simplex4DVariant.IMRPOVE_XYZ -> OpenSimplex2S.noise4_ImproveXYZ(seed, x, y, z, w);
            case Simplex4DVariant.CLASSIC -> OpenSimplex2S.noise4_Fallback(seed, x, y, z, w);
        };
    }

    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public static SuperSimplexNoiseBuilder newBuilder() {
        return new SuperSimplexNoiseBuilder();
    }

    @NullMarked
    public static final class SuperSimplexNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private Simplex2DVariant variant2D = Simplex2DVariant.CLASSIC;
        private Simplex3DVariant variant3D = Simplex3DVariant.CLASSIC;
        private Simplex4DVariant variant4D = Simplex4DVariant.CLASSIC;

        private SuperSimplexNoiseBuilder() {
        }

        public SuperSimplexNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public SuperSimplexNoiseBuilder setVariant2D(Simplex2DVariant variant2D) {
            this.variant2D = variant2D;
            return this;
        }

        public SuperSimplexNoiseBuilder setVariant3D(Simplex3DVariant variant3D) {
            this.variant3D = variant3D;
            return this;
        }

        public SuperSimplexNoiseBuilder setVariant4D(Simplex4DVariant variant4D) {
            this.variant4D = variant4D;
            return this;
        }

        public SuperSimplexNoiseGenerator build() {
            return new SuperSimplexNoiseGenerator(this.seed, this.variant2D, this.variant3D, this.variant4D);
        }
    }
}

