/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.pattern;

import de.articdive.jnoise.core.api.noisegen.NoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CylinderNoiseGenerator
implements NoiseGenerator {
    private CylinderNoiseGenerator() {
    }

    public double evaluateNoise(double x) {
        throw new UnsupportedOperationException("Cannot generate a cylinder in 1D space.");
    }

    public double evaluateNoise(double x, double y) {
        double distFromCenter = Math.sqrt(x * x);
        double distFromSmallerSphere = distFromCenter - Math.floor(distFromCenter);
        double distFromLargerSphere = Math.ceil(distFromCenter) - distFromCenter;
        return 1.0 - 2.0 * Math.min(distFromSmallerSphere, distFromLargerSphere);
    }

    public double evaluateNoise(double x, double y, double z) {
        double distFromCenter = Math.sqrt(x * x + y * y);
        double distFromSmallerSphere = distFromCenter - Math.floor(distFromCenter);
        double distFromLargerSphere = 1.0 - distFromSmallerSphere;
        return 1.0 - 2.0 * Math.min(distFromSmallerSphere, distFromLargerSphere);
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        double distFromCenter = Math.sqrt(x * x + y * y + z * z);
        double distFromSmallerSphere = distFromCenter - Math.floor(distFromCenter);
        double distFromLargerSphere = 1.0 - distFromSmallerSphere;
        return 1.0 - 2.0 * Math.min(distFromSmallerSphere, distFromLargerSphere);
    }

    public static CylinderNoiseBuilder newBuilder() {
        return new CylinderNoiseBuilder();
    }

    @NullMarked
    public static final class CylinderNoiseBuilder
    implements NoiseSourceBuilder {
        private CylinderNoiseBuilder() {
        }

        public CylinderNoiseGenerator build() {
            return new CylinderNoiseGenerator();
        }
    }
}

