/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.perlin;

import de.articdive.jnoise.core.api.functions.Interpolation;
import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.core.util.HashUtil;
import de.articdive.jnoise.core.util.vectors.Vector1D;
import de.articdive.jnoise.core.util.vectors.Vector2D;
import de.articdive.jnoise.core.util.vectors.Vector3D;
import de.articdive.jnoise.core.util.vectors.Vector4D;
import de.articdive.jnoise.generators.noise_parameters.fade_functions.FadeFunction;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PerlinNoiseGenerator
implements SeededNoiseGenerator {
    private static final Vector1D[] VECTOR_1D = new Vector1D[]{new Vector1D(1.0), new Vector1D(-1.0)};
    private static final Vector2D[] VECTOR_2D = new Vector2D[]{new Vector2D(1.0, 1.0), new Vector2D(-1.0, 1.0), new Vector2D(1.0, -1.0), new Vector2D(-1.0, -1.0), new Vector2D(0.0, 1.0), new Vector2D(0.0, -1.0), new Vector2D(1.0, 0.0), new Vector2D(-1.0, 0.0)};
    private static final Vector3D[] VECTOR_3D = new Vector3D[]{new Vector3D(1.0, 1.0, 1.0), new Vector3D(-1.0, 1.0, 1.0), new Vector3D(1.0, -1.0, 1.0), new Vector3D(-1.0, -1.0, 1.0), new Vector3D(1.0, 1.0, -1.0), new Vector3D(-1.0, 1.0, -1.0), new Vector3D(1.0, -1.0, -1.0), new Vector3D(-1.0, -1.0, -1.0), new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, -1.0, 1.0), new Vector3D(0.0, 1.0, -1.0), new Vector3D(0.0, -1.0, -1.0), new Vector3D(1.0, 0.0, 1.0), new Vector3D(-1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, -1.0), new Vector3D(-1.0, 0.0, -1.0), new Vector3D(1.0, 1.0, 0.0), new Vector3D(-1.0, 1.0, 0.0), new Vector3D(1.0, -1.0, 0.0), new Vector3D(-1.0, -1.0, 0.0)};
    private static final Vector4D[] VECTOR_4D = new Vector4D[]{new Vector4D(1.0, 1.0, 1.0, 1.0), new Vector4D(1.0, 1.0, -1.0, 1.0), new Vector4D(1.0, -1.0, 1.0, 1.0), new Vector4D(1.0, -1.0, -1.0, 1.0), new Vector4D(-1.0, 1.0, 1.0, 1.0), new Vector4D(-1.0, 1.0, -1.0, 1.0), new Vector4D(-1.0, -1.0, 1.0, 1.0), new Vector4D(-1.0, -1.0, -1.0, 1.0), new Vector4D(1.0, 1.0, 1.0, -1.0), new Vector4D(1.0, 1.0, -1.0, -1.0), new Vector4D(1.0, -1.0, 1.0, -1.0), new Vector4D(1.0, -1.0, -1.0, -1.0), new Vector4D(-1.0, 1.0, 1.0, -1.0), new Vector4D(-1.0, 1.0, -1.0, -1.0), new Vector4D(-1.0, -1.0, 1.0, -1.0), new Vector4D(-1.0, -1.0, -1.0, -1.0), new Vector4D(0.0, 1.0, 1.0, 1.0), new Vector4D(0.0, 1.0, -1.0, 1.0), new Vector4D(0.0, -1.0, 1.0, 1.0), new Vector4D(0.0, -1.0, -1.0, 1.0), new Vector4D(0.0, 1.0, 1.0, -1.0), new Vector4D(0.0, 1.0, -1.0, -1.0), new Vector4D(0.0, -1.0, 1.0, -1.0), new Vector4D(0.0, -1.0, -1.0, -1.0), new Vector4D(1.0, 0.0, 1.0, 1.0), new Vector4D(1.0, 0.0, -1.0, 1.0), new Vector4D(-1.0, 0.0, 1.0, 1.0), new Vector4D(-1.0, 0.0, -1.0, 1.0), new Vector4D(1.0, 0.0, 1.0, -1.0), new Vector4D(1.0, 0.0, -1.0, -1.0), new Vector4D(-1.0, 0.0, 1.0, -1.0), new Vector4D(-1.0, 0.0, -1.0, -1.0), new Vector4D(1.0, 1.0, 0.0, 1.0), new Vector4D(1.0, -1.0, 0.0, 1.0), new Vector4D(-1.0, 1.0, 0.0, 1.0), new Vector4D(-1.0, -1.0, 0.0, 1.0), new Vector4D(1.0, 1.0, 0.0, -1.0), new Vector4D(1.0, -1.0, 0.0, -1.0), new Vector4D(-1.0, 1.0, 0.0, -1.0), new Vector4D(-1.0, -1.0, 0.0, -1.0), new Vector4D(1.0, 1.0, 1.0, 0.0), new Vector4D(1.0, -1.0, 1.0, 0.0), new Vector4D(-1.0, 1.0, 1.0, 0.0), new Vector4D(-1.0, -1.0, 1.0, 0.0), new Vector4D(1.0, 1.0, -1.0, 0.0), new Vector4D(1.0, -1.0, -1.0, 0.0), new Vector4D(-1.0, 1.0, -1.0, 0.0), new Vector4D(-1.0, -1.0, -1.0, 0.0)};
    private final long seed;
    private final Interpolation interpolation;
    private final FadeFunction fadeFunction;

    private PerlinNoiseGenerator(long seed, Interpolation interpolation, FadeFunction fadeFunction) {
        this.seed = seed;
        this.interpolation = interpolation;
        this.fadeFunction = fadeFunction;
    }

    public double evaluateNoise(double x, long seed) {
        long iX = (long)Math.floor(x);
        double[] fractals = new double[]{this.fadeFunction.fade(x -= (double)iX)};
        double[] dots = new double[]{new Vector1D(x).dot(VECTOR_1D[HashUtil.hash1D((long)seed, (long)iX) & 1]), new Vector1D(x - 1.0).dot(VECTOR_1D[HashUtil.hash1D((long)seed, (long)(iX + 1L)) & 1])};
        return this.interpolation.lerp(fractals, dots);
    }

    public double evaluateNoise(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        double[] fractals = new double[]{this.fadeFunction.fade(x -= (double)iX), this.fadeFunction.fade(y -= (double)iY)};
        double[] dots = new double[]{new Vector2D(x, y).dot(VECTOR_2D[HashUtil.hash2D((long)seed, (long)iX, (long)iY) & 7]), new Vector2D(x - 1.0, y).dot(VECTOR_2D[HashUtil.hash2D((long)seed, (long)(iX + 1L), (long)iY) & 7]), new Vector2D(x, y - 1.0).dot(VECTOR_2D[HashUtil.hash2D((long)seed, (long)iX, (long)(iY + 1L)) & 7]), new Vector2D(x - 1.0, y - 1.0).dot(VECTOR_2D[HashUtil.hash2D((long)seed, (long)(iX + 1L), (long)(iY + 1L)) & 7])};
        return this.interpolation.lerp(fractals, dots);
    }

    public double evaluateNoise(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        double[] fractals = new double[]{this.fadeFunction.fade(x -= (double)iX), this.fadeFunction.fade(y -= (double)iY), this.fadeFunction.fade(z -= (double)iZ)};
        double[] dots = new double[]{new Vector3D(x, y, z).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)iX, (long)iY, (long)iZ) & 0x13]), new Vector3D(x - 1.0, y, z).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)(iX + 1L), (long)iY, (long)iZ) & 0x13]), new Vector3D(x, y - 1.0, z).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)iX, (long)(iY + 1L), (long)iZ) & 0x13]), new Vector3D(x - 1.0, y - 1.0, z).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)iZ) & 0x13]), new Vector3D(x, y, z - 1.0).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)iX, (long)iY, (long)(iZ + 1L)) & 0x13]), new Vector3D(x - 1.0, y, z - 1.0).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)(iX + 1L), (long)iY, (long)(iZ + 1L)) & 0x13]), new Vector3D(x, y - 1.0, z - 1.0).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)iX, (long)(iY + 1L), (long)(iZ + 1L)) & 0x13]), new Vector3D(x - 1.0, y - 1.0, z - 1.0).dot(VECTOR_3D[HashUtil.hash3D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)(iZ + 1L)) & 0x13])};
        return this.interpolation.lerp(fractals, dots);
    }

    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        double[] fractals = new double[]{this.fadeFunction.fade(x -= (double)iX), this.fadeFunction.fade(y -= (double)iY), this.fadeFunction.fade(z -= (double)iZ), this.fadeFunction.fade(w -= (double)iW)};
        double[] dots = new double[]{new Vector4D(x, y, z, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)iY, (long)iZ, (long)iW) & 0x2F]), new Vector4D(x - 1.0, y, z, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)iY, (long)iZ, (long)iW) & 0x2F]), new Vector4D(x, y - 1.0, z, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)(iY + 1L), (long)iZ, (long)iW) & 0x2F]), new Vector4D(x - 1.0, y - 1.0, z, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)iZ, (long)iW) & 0x2F]), new Vector4D(x, y, z - 1.0, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)iY, (long)(iZ + 1L), (long)iW) & 0x2F]), new Vector4D(x - 1.0, y, z - 1.0, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)iY, (long)(iZ + 1L), (long)iW) & 0x2F]), new Vector4D(x, y - 1.0, z - 1.0, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)(iY + 1L), (long)(iZ + 1L), (long)iW) & 0x2F]), new Vector4D(x - 1.0, y - 1.0, z - 1.0, w).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)(iZ + 1L), (long)iW) & 0x2F]), new Vector4D(x, y, z, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)iY, (long)iZ, (long)(iW + 1L)) & 0x2F]), new Vector4D(x - 1.0, y, z, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)iY, (long)iZ, (long)(iW + 1L)) & 0x2F]), new Vector4D(x, y - 1.0, z, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)(iY + 1L), (long)iZ, (long)(iW + 1L)) & 0x2F]), new Vector4D(x - 1.0, y - 1.0, z, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)iZ, (long)(iW + 1L)) & 0x2F]), new Vector4D(x, y, z - 1.0, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)iY, (long)(iZ + 1L), (long)(iW + 1L)) & 0x2F]), new Vector4D(x - 1.0, y, z - 1.0, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)iY, (long)(iZ + 1L), (long)(iW + 1L)) & 0x2F]), new Vector4D(x, y - 1.0, z - 1.0, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)iX, (long)(iY + 1L), (long)(iZ + 1L), (long)(iW + 1L)) & 0x2F]), new Vector4D(x - 1.0, y - 1.0, z - 1.0, w - 1.0).dot(VECTOR_4D[HashUtil.hash4D((long)seed, (long)(iX + 1L), (long)(iY + 1L), (long)(iZ + 1L), (long)(iW + 1L)) & 0x2F])};
        return this.interpolation.lerp(fractals, dots);
    }

    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public static PerlinNoiseBuilder newBuilder() {
        return new PerlinNoiseBuilder();
    }

    @NullMarked
    public static final class PerlinNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private Interpolation interpolation = Interpolation.LINEAR;
        private FadeFunction fadeFunction = FadeFunction.QUINTIC_POLY;

        private PerlinNoiseBuilder() {
        }

        public PerlinNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public PerlinNoiseBuilder setInterpolation(Interpolation interpolation) {
            this.interpolation = interpolation;
            return this;
        }

        public PerlinNoiseBuilder setFadeFunction(FadeFunction fadeFunction) {
            this.fadeFunction = fadeFunction;
            return this;
        }

        public PerlinNoiseGenerator build() {
            return new PerlinNoiseGenerator(this.seed, this.interpolation, this.fadeFunction);
        }
    }
}

