/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.random.gaussian;

import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.core.util.HashUtil;
import java.util.Random;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GaussianWhiteNoiseGenerator
implements SeededNoiseGenerator {
    private final long seed;
    private final double mean;
    private final double stddev;

    private GaussianWhiteNoiseGenerator(long seed, double mean, double stddev) {
        this.seed = seed;
        this.mean = mean;
        this.stddev = stddev;
    }

    public double evaluateNoise(double x, long seed) {
        long iX = (long)Math.floor(x);
        Random random = new Random(HashUtil.hash1D((long)seed, (long)iX));
        return random.nextGaussian(this.mean, this.stddev);
    }

    public double evaluateNoise(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        Random random = new Random(HashUtil.hash2D((long)seed, (long)iX, (long)iY));
        return random.nextGaussian(this.mean, this.stddev);
    }

    public double evaluateNoise(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        Random random = new Random(HashUtil.hash3D((long)seed, (long)iX, (long)iY, (long)iZ));
        return random.nextGaussian(this.mean, this.stddev);
    }

    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        Random random = new Random(HashUtil.hash4D((long)seed, (long)iX, (long)iY, (long)iZ, (long)iW));
        return random.nextGaussian(this.mean, this.stddev);
    }

    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public static GaussianWhiteNoiseBuilder newBuilder() {
        return new GaussianWhiteNoiseBuilder();
    }

    @NullMarked
    public static final class GaussianWhiteNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private double mean = 0.0;
        private double stddev = 0.3333333333333333;

        private GaussianWhiteNoiseBuilder() {
        }

        public GaussianWhiteNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public GaussianWhiteNoiseBuilder setMean(double mean) {
            this.mean = mean;
            return this;
        }

        public GaussianWhiteNoiseBuilder setStandardDeviation(double stddev) {
            this.stddev = stddev;
            return this;
        }

        public GaussianWhiteNoiseGenerator build() {
            return new GaussianWhiteNoiseGenerator(this.seed, this.mean, this.stddev);
        }
    }
}

