/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.value;

import de.articdive.jnoise.core.api.functions.Interpolation;
import de.articdive.jnoise.core.api.noisegen.SeededNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.generators.noise_parameters.fade_functions.FadeFunction;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ValueNoiseGenerator
implements SeededNoiseGenerator {
    private final long seed;
    private final Interpolation interpolation;
    private final FadeFunction fadeFunction;

    private ValueNoiseGenerator(long seed, Interpolation interpolation, FadeFunction fadeFunction) {
        this.seed = seed;
        this.interpolation = interpolation;
        this.fadeFunction = fadeFunction;
    }

    public double evaluateNoise(double x, long seed) {
        long iX = (long)Math.floor(x);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord1D((int)iX, seed), ValueNoiseGenerator.evaluateCoord1D((int)iX + 1, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    public double evaluateNoise(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord2D((int)iX, (int)iY, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX + 1, (int)iY, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX, (int)iY + 1, seed), ValueNoiseGenerator.evaluateCoord2D((int)iX + 1, (int)iY + 1, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    public double evaluateNoise(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY), this.fadeFunction.fade(z - (double)iZ)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord3D(iX, iY, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY + 1L, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY + 1L, iZ, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX, iY + 1L, iZ + 1L, seed), ValueNoiseGenerator.evaluateCoord3D(iX + 1L, iY + 1L, iZ + 1L, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        double[] fractals = new double[]{this.fadeFunction.fade(x - (double)iX), this.fadeFunction.fade(y - (double)iY), this.fadeFunction.fade(z - (double)iZ), this.fadeFunction.fade(w - (double)iW)};
        double[] vals = new double[]{ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ + 1L, iW, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX, iY + 1L, iZ + 1L, iW + 1L, seed), ValueNoiseGenerator.evaluateCoord4D(iX + 1L, iY + 1L, iZ + 1L, iW + 1L, seed)};
        return this.interpolation.lerp(fractals, vals);
    }

    public double evaluateNoise(double x) {
        return this.evaluateNoise(x, this.seed);
    }

    public double evaluateNoise(double x, double y) {
        return this.evaluateNoise(x, y, this.seed);
    }

    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoise(x, y, z, this.seed);
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoise(x, y, z, w, this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    private static double evaluateCoord1D(long x, long seed) {
        int n = (int)(seed ^ 1619L * x);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord2D(long x, long y, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord3D(long x, long y, long z, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    private static double evaluateCoord4D(long x, long y, long z, long w, long seed) {
        int n = (int)(seed ^ 1619L * x);
        n = (int)((long)n ^ 31337L * y);
        n = (int)((long)n ^ 6971L * z);
        n = (int)((long)n ^ 1013L * w);
        return (double)(n * n * n * 60493) / 2.147483648E9;
    }

    public static ValueNoiseBuilder newBuilder() {
        return new ValueNoiseBuilder();
    }

    @NullMarked
    public static final class ValueNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private Interpolation interpolation = Interpolation.LINEAR;
        private FadeFunction fadeFunction = FadeFunction.QUINTIC_POLY;

        private ValueNoiseBuilder() {
        }

        public ValueNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public ValueNoiseBuilder setInterpolation(Interpolation interpolation) {
            this.interpolation = interpolation;
            return this;
        }

        public ValueNoiseBuilder setFadeFunction(FadeFunction fadeFunction) {
            this.fadeFunction = fadeFunction;
            return this;
        }

        public ValueNoiseGenerator build() {
            return new ValueNoiseGenerator(this.seed, this.interpolation, this.fadeFunction);
        }
    }
}

