/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noisegen.worley;

import de.articdive.jnoise.core.api.functions.Combiner;
import de.articdive.jnoise.core.api.noisegen.SeededExplicitNoiseGenerator;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.core.util.HashUtil;
import de.articdive.jnoise.core.util.vectors.Vector;
import de.articdive.jnoise.core.util.vectors.Vector1D;
import de.articdive.jnoise.core.util.vectors.Vector2D;
import de.articdive.jnoise.core.util.vectors.Vector3D;
import de.articdive.jnoise.core.util.vectors.Vector4D;
import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunction;
import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunctionType;
import de.articdive.jnoise.generators.noise_parameters.return_type_functions.ReturnDistanceFunction;
import de.articdive.jnoise.generators.noise_parameters.return_type_functions.ReturnDistanceFunctionType;
import de.articdive.jnoise.generators.noisegen.worley.WorleyNoiseResult;
import java.util.Arrays;
import java.util.Random;
import java.util.function.IntToLongFunction;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class WorleyNoiseGenerator
implements SeededExplicitNoiseGenerator<WorleyNoiseResult<Vector>> {
    private final long seed;
    private final int depth;
    private final DistanceFunction distanceFunction;
    private final IntToLongFunction fpAmountFunction;
    private final ReturnDistanceFunction returnDistanceFunction;
    private final Combiner minFunction;

    private WorleyNoiseGenerator(long seed, int depth, DistanceFunction distanceFunction, IntToLongFunction fpAmountFunction, ReturnDistanceFunction returnDistanceFunction, Combiner minFunction) {
        this.seed = seed;
        this.depth = depth;
        this.distanceFunction = distanceFunction;
        this.fpAmountFunction = fpAmountFunction;
        this.returnDistanceFunction = returnDistanceFunction;
        this.minFunction = minFunction;
    }

    public double evaluateNoise(double x, long seed) {
        return this.evaluateNoiseResult(x, seed).getValue();
    }

    public double evaluateNoise(double x, double y, long seed) {
        return this.evaluateNoiseResult(x, y, seed).getValue();
    }

    public double evaluateNoise(double x, double y, double z, long seed) {
        return this.evaluateNoiseResult(x, y, z, seed).getValue();
    }

    public double evaluateNoise(double x, double y, double z, double w, long seed) {
        return this.evaluateNoiseResult(x, y, z, w, seed).getValue();
    }

    public double evaluateNoise(double x) {
        return this.evaluateNoiseResult(x, this.seed).getValue();
    }

    public double evaluateNoise(double x, double y) {
        return this.evaluateNoiseResult(x, y, this.seed).getValue();
    }

    public double evaluateNoise(double x, double y, double z) {
        return this.evaluateNoiseResult(x, y, z, this.seed).getValue();
    }

    public double evaluateNoise(double x, double y, double z, double w) {
        return this.evaluateNoiseResult(x, y, z, w, this.seed).getValue();
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, long seed) {
        long iX = (long)Math.floor(x);
        double[] distancesStack = new double[this.depth];
        Arrays.fill(distancesStack, Double.MAX_VALUE);
        Vector1D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            int hash = HashUtil.hash1D((long)seed, (long)secX);
            Random fpRNG = new Random(hash);
            int i = 0;
            while ((long)i < Math.max(1L, this.fpAmountFunction.applyAsLong(hash))) {
                double pointX = fpRNG.nextDouble() + (double)secX;
                double distance = this.distanceFunction.distance(x, pointX);
                for (int d = this.depth - 1; d >= 1; --d) {
                    distancesStack[d] = Math.max(this.minFunction.applyTo(distancesStack[d], distance), distancesStack[d - 1]);
                }
                if (distance < distancesStack[0]) {
                    distancesStack[0] = this.minFunction.applyTo(distance, distancesStack[0]);
                    closestPoint = new Vector1D(pointX);
                }
                ++i;
            }
        }
        return new WorleyNoiseResult<Object>(this.returnDistanceFunction.applyAsDouble(distancesStack), closestPoint);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        double[] distancesStack = new double[this.depth];
        Arrays.fill(distancesStack, Double.MAX_VALUE);
        Vector2D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                int hash = HashUtil.hash2D((long)seed, (long)secX, (long)secY);
                Random fpRNG = new Random(hash);
                int i = 0;
                while ((long)i < Math.max(1L, this.fpAmountFunction.applyAsLong(hash))) {
                    double pointX = fpRNG.nextDouble() + (double)secX;
                    double pointY = fpRNG.nextDouble() + (double)secY;
                    double distance = this.distanceFunction.distance(x, y, pointX, pointY);
                    for (int d = this.depth - 1; d >= 1; --d) {
                        distancesStack[d] = Math.max(this.minFunction.applyTo(distancesStack[d], distance), distancesStack[d - 1]);
                    }
                    if (distance < distancesStack[0]) {
                        distancesStack[0] = this.minFunction.applyTo(distance, distancesStack[0]);
                        closestPoint = new Vector2D(pointX, pointY);
                    }
                    ++i;
                }
            }
        }
        return new WorleyNoiseResult<Object>(this.returnDistanceFunction.applyAsDouble(distancesStack), closestPoint);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        double[] distancesStack = new double[this.depth];
        Arrays.fill(distancesStack, Double.MAX_VALUE);
        Vector3D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    long secZ = iZ + (long)zOffset;
                    int hash = HashUtil.hash3D((long)seed, (long)secX, (long)secY, (long)secZ);
                    Random fpRNG = new Random(hash);
                    int i = 0;
                    while ((long)i < Math.max(1L, this.fpAmountFunction.applyAsLong(hash))) {
                        double pointX = fpRNG.nextDouble() + (double)secX;
                        double pointY = fpRNG.nextDouble() + (double)secY;
                        double pointZ = fpRNG.nextDouble() + (double)secZ;
                        double distance = this.distanceFunction.distance(x, y, z, pointX, pointY, pointZ);
                        for (int d = this.depth - 1; d >= 1; --d) {
                            distancesStack[d] = Math.max(this.minFunction.applyTo(distancesStack[d], distance), distancesStack[d - 1]);
                        }
                        if (distance < distancesStack[0]) {
                            distancesStack[0] = this.minFunction.applyTo(distance, distancesStack[0]);
                            closestPoint = new Vector3D(pointX, pointY, pointZ);
                        }
                        ++i;
                    }
                }
            }
        }
        return new WorleyNoiseResult<Object>(this.returnDistanceFunction.applyAsDouble(distancesStack), closestPoint);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, double w, long seed) {
        long iX = (long)Math.floor(x);
        long iY = (long)Math.floor(y);
        long iZ = (long)Math.floor(z);
        long iW = (long)Math.floor(w);
        double[] distancesStack = new double[this.depth];
        Arrays.fill(distancesStack, Double.MAX_VALUE);
        Vector4D closestPoint = null;
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            long secX = iX + (long)xOffset;
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                long secY = iY + (long)yOffset;
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    long secZ = iZ + (long)zOffset;
                    for (int wOffset = -1; wOffset <= 1; ++wOffset) {
                        long secW = iW + (long)wOffset;
                        int hash = HashUtil.hash4D((long)seed, (long)secX, (long)secY, (long)secZ, (long)secW);
                        Random fpRNG = new Random(hash);
                        int i = 0;
                        while ((long)i < this.fpAmountFunction.applyAsLong(hash)) {
                            double pointX = fpRNG.nextDouble() + (double)secX;
                            double pointY = fpRNG.nextDouble() + (double)secY;
                            double pointZ = fpRNG.nextDouble() + (double)secZ;
                            double pointW = fpRNG.nextDouble() + (double)secW;
                            double distance = this.distanceFunction.distance(x, y, z, w, pointX, pointY, pointZ, pointW);
                            for (int d = this.depth - 1; d >= 1; --d) {
                                distancesStack[d] = Math.max(this.minFunction.applyTo(distancesStack[d], distance), distancesStack[d - 1]);
                            }
                            if (distance < distancesStack[0]) {
                                distancesStack[0] = this.minFunction.applyTo(distance, distancesStack[0]);
                                closestPoint = new Vector4D(pointX, pointY, pointZ, pointW);
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        return new WorleyNoiseResult<Object>(this.returnDistanceFunction.applyAsDouble(distancesStack), closestPoint);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x) {
        return this.evaluateNoiseResult(x, this.seed);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y) {
        return this.evaluateNoiseResult(x, y, this.seed);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z) {
        return this.evaluateNoiseResult(x, y, z, this.seed);
    }

    public WorleyNoiseResult<Vector> evaluateNoiseResult(double x, double y, double z, double w) {
        return this.evaluateNoiseResult(x, y, z, w, this.seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public static WorleyNoiseBuilder newBuilder() {
        return new WorleyNoiseBuilder();
    }

    @NullMarked
    public static final class WorleyNoiseBuilder
    implements NoiseSourceBuilder {
        private long seed = 1729L;
        private int depth = 1;
        private DistanceFunction distanceFunction = DistanceFunctionType.EUCLIDEAN_SQUARED;
        private IntToLongFunction fpAmountFunction = i -> 1L;
        private ReturnDistanceFunction returnDistanceFunction = ReturnDistanceFunctionType.DISTANCE_0;
        private Combiner minFunction = Combiner.MIN;

        private WorleyNoiseBuilder() {
        }

        public WorleyNoiseBuilder setSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public WorleyNoiseBuilder setDepth(int depth) {
            this.depth = depth;
            return this;
        }

        public WorleyNoiseBuilder setDistanceFunction(DistanceFunction distanceFunction) {
            this.distanceFunction = distanceFunction;
            return this;
        }

        public WorleyNoiseBuilder setFeaturePointAmountFunction(IntToLongFunction fpAmountFunction) {
            this.fpAmountFunction = fpAmountFunction;
            return this;
        }

        public WorleyNoiseBuilder setReturnDistanceFunction(ReturnDistanceFunction returnDistanceFunction) {
            this.returnDistanceFunction = returnDistanceFunction;
            return this;
        }

        public WorleyNoiseBuilder setMinFunction(Combiner minFunction) {
            this.minFunction = minFunction;
            return this;
        }

        public WorleyNoiseGenerator build() {
            if (!this.returnDistanceFunction.isValidArrayLength(this.depth)) {
                throw new IllegalArgumentException("Invalid depth for the specified return distance function!");
            }
            return new WorleyNoiseGenerator(this.seed, this.depth, this.distanceFunction, this.fpAmountFunction, this.returnDistanceFunction, this.minFunction);
        }
    }
}

