/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest.api;

import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.model.ErrorCollection;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface DirectoriesResource {
    @GET
    @Produces(value={"application/json"})
    @Operation(tags={"directories"}, summary="Get all user directories", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=DirectoriesBean.class))}, description="Returns all directories."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getDirectories();

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Operation(tags={"directories"}, summary="Get a user directory", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AbstractDirectoryBean.class))}, description="Returns the requested directory."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getDirectory(@PathParam(value="id") long var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"directories"}, summary="Set or update a list of user directories", description="NOTE: All existing directories with the same 'name' attribute are updated.", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=DirectoriesBean.class))}, description="Returns all directories."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setDirectories(@QueryParam(value="test-connection") @DefaultValue(value="false") boolean var1, @NotNull DirectoriesBean var2);

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"directories"}, summary="Update a user directory", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AbstractDirectoryBean.class))}, description="Returns the updated directory."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setDirectory(@PathParam(value="id") long var1, @QueryParam(value="test-connection") @DefaultValue(value="false") boolean var3, @NotNull AbstractDirectoryBean var4);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"directories"}, summary="Add a user directory", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AbstractDirectoryBean.class))}, description="Returns the added directory."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response addDirectory(@QueryParam(value="test-connection") @DefaultValue(value="false") boolean var1, @NotNull AbstractDirectoryBean var2);

    @DELETE
    @Operation(tags={"directories"}, summary="Delete all user directories", description="NOTE: The 'force' parameter must be set to 'true' in order to execute this request.", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteDirectories(@QueryParam(value="force") boolean var1);

    @DELETE
    @Path(value="{id}")
    @Operation(tags={"directories"}, summary="Delete a user directory", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteDirectory(@PathParam(value="id") long var1);
}

