/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest;

import com.sun.jersey.spi.container.ResourceFilters;
import de.aservo.confapi.crowd.filter.SysadminOnlyResourceFilter;
import de.aservo.confapi.crowd.model.ApplicationBean;
import de.aservo.confapi.crowd.model.ApplicationsBean;
import de.aservo.confapi.crowd.rest.api.ApplicationsResource;
import de.aservo.confapi.crowd.service.api.ApplicationsService;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="applications")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@Component
public class ApplicationsResourceImpl
implements ApplicationsResource {
    private final ApplicationsService applicationsService;

    @Inject
    public ApplicationsResourceImpl(ApplicationsService applicationsService) {
        this.applicationsService = applicationsService;
    }

    @Override
    public Response getApplications() {
        return Response.ok((Object)this.applicationsService.getApplications()).build();
    }

    @Override
    public Response getApplication(long id) {
        return Response.ok((Object)this.applicationsService.getApplication(id)).build();
    }

    @Override
    public Response setApplications(ApplicationsBean applicationsBean) {
        return Response.ok((Object)this.applicationsService.setApplications(applicationsBean)).build();
    }

    @Override
    public Response setApplication(long id, ApplicationBean applicationBean) {
        return Response.ok((Object)this.applicationsService.setApplication(id, applicationBean)).build();
    }

    @Override
    public Response addApplication(ApplicationBean applicationBean) {
        return Response.ok((Object)this.applicationsService.addApplication(applicationBean)).build();
    }

    @Override
    public Response deleteApplications(boolean force) {
        this.applicationsService.deleteApplications(force);
        return Response.ok().build();
    }

    @Override
    public Response deleteApplication(long id) {
        this.applicationsService.deleteApplication(id);
        return Response.ok().build();
    }
}

