/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest.api;

import de.aservo.confapi.commons.model.ErrorCollection;
import de.aservo.confapi.crowd.model.ApplicationBean;
import de.aservo.confapi.crowd.model.ApplicationsBean;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface ApplicationsResource {
    @GET
    @Produces(value={"application/json"})
    @Operation(tags={"applications"}, summary="Get all applications", description="Upon successful request, returns a `ApplicationsBean` object containing all applications", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationsBean.class))}, description="Returns all applications."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getApplications();

    @GET
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"applications"}, summary="Get an application", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationsBean.class))}, description="Returns the requested application."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getApplication(@PathParam(value="id") long var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"applications"}, summary="Set or update a list of applications", description="NOTE: All existing applications with the same 'name' attribute are updated.", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationsBean.class))}, description="Returns all applications."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setApplications(ApplicationsBean var1);

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"applications"}, summary="Update an application", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationBean.class))}, description="Returns the updated application."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setApplication(@PathParam(value="id") long var1, ApplicationBean var3);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"applications"}, summary="Add an application", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ApplicationBean.class))}, description="Returns the added application."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response addApplication(ApplicationBean var1);

    @DELETE
    @Operation(tags={"applications"}, summary="Delete all applications", description="NOTE: The 'force' parameter must be se to 'true' in order to execute this request.", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteApplications(@QueryParam(value="force") boolean var1);

    @DELETE
    @Path(value="{id}")
    @Operation(tags={"applications"}, summary="Delete an application", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteApplication(@PathParam(value="id") long var1);
}

