/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.exception.ServiceUnavailableException;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.model.DirectoryInternalBean;
import de.aservo.confapi.commons.service.api.DirectoriesService;
import de.aservo.confapi.commons.service.api.UsersService;
import de.aservo.confapi.crowd.exception.NotFoundExceptionForDirectory;
import de.aservo.confapi.crowd.model.util.DirectoryBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={DirectoriesService.class})
public class DirectoriesServiceImpl
implements DirectoriesService {
    private static final int RETRY_AFTER_IN_SECONDS = 5;
    @ComponentImport
    private final DirectoryManager directoryManager;
    private final UsersService usersService;

    @Inject
    public DirectoriesServiceImpl(DirectoryManager directoryManager, UsersService usersService) {
        this.directoryManager = directoryManager;
        this.usersService = usersService;
    }

    @Override
    public DirectoriesBean getDirectories() {
        return new DirectoriesBean(this.findAllDirectories().stream().map(DirectoryBeanUtil::toDirectoryBean).collect(Collectors.toList()));
    }

    @Override
    public AbstractDirectoryBean getDirectory(long id) {
        Directory directory = this.findDirectory(id);
        return DirectoryBeanUtil.toDirectoryBean(directory);
    }

    @Override
    public DirectoriesBean setDirectories(@NotNull DirectoriesBean directoriesBean, boolean testConnection) {
        Map existingDirectoriesByName = this.findAllDirectories().stream().collect(Collectors.toMap(Directory::getName, Function.identity()));
        ArrayList<AbstractDirectoryBean> resultDirectories = new ArrayList<AbstractDirectoryBean>();
        for (AbstractDirectoryBean directoryBean : directoriesBean.getDirectories()) {
            if (existingDirectoriesByName.containsKey(directoryBean.getName())) {
                resultDirectories.add(this.setDirectory(((Directory)existingDirectoriesByName.get(directoryBean.getName())).getId(), directoryBean, testConnection));
                continue;
            }
            resultDirectories.add(this.addDirectory(directoryBean, testConnection));
        }
        return new DirectoriesBean(resultDirectories);
    }

    @Override
    public AbstractDirectoryBean setDirectory(long id, @NotNull AbstractDirectoryBean directoryBean, boolean testConnection) {
        AbstractDirectoryBean resultDirectoryBean;
        Directory existingDirectory = this.findDirectory(id);
        try {
            Directory mergedDirectory = DirectoryBeanUtil.toDirectory(directoryBean, existingDirectory);
            Directory updatedDirectory = this.directoryManager.updateDirectory(mergedDirectory);
            resultDirectoryBean = DirectoryBeanUtil.toDirectoryBean(updatedDirectory);
        }
        catch (DirectoryBeanUtil.UnsupportedDirectoryBeanException e) {
            throw new BadRequestException(String.format("Setting directory type '%s' is not supported (yet)", e.getMessage()));
        }
        catch (DirectoryNotFoundException e) {
            throw new InternalServerErrorException(String.format("When trying to update directory '%s', it could not be found anymore", existingDirectory.getName()));
        }
        if (DirectoryInternalBean.class.equals(directoryBean.getClass()) && directoryBean.getClass().equals(resultDirectoryBean.getClass())) {
            DirectoryInternalBean directoryInternalBean = (DirectoryInternalBean)directoryBean;
            DirectoryInternalBean resultDirectoryInternalBean = (DirectoryInternalBean)resultDirectoryBean;
            resultDirectoryInternalBean.setUsers(this.usersService.setUsers(resultDirectoryInternalBean.getId(), directoryInternalBean.getUsers()));
        }
        return resultDirectoryBean;
    }

    @Override
    public AbstractDirectoryBean addDirectory(@NotNull AbstractDirectoryBean directoryBean, boolean testConnection) {
        AbstractDirectoryBean resultDirectoryBean;
        try {
            Directory directory = DirectoryBeanUtil.toDirectory(directoryBean);
            Directory addedDirectory = this.directoryManager.addDirectory(directory);
            resultDirectoryBean = DirectoryBeanUtil.toDirectoryBean(addedDirectory);
        }
        catch (DirectoryBeanUtil.UnsupportedDirectoryBeanException e) {
            throw new BadRequestException(String.format("Adding directory type '%s' is not supported (yet)", e.getMessage()));
        }
        catch (DirectoryInstantiationException e) {
            throw new InternalServerErrorException(String.format("Could not create directory '%s'", directoryBean.getName()));
        }
        if (DirectoryInternalBean.class.equals(directoryBean.getClass()) && directoryBean.getClass().equals(resultDirectoryBean.getClass())) {
            DirectoryInternalBean directoryInternalBean = (DirectoryInternalBean)directoryBean;
            DirectoryInternalBean resultDirectoryInternalBean = (DirectoryInternalBean)resultDirectoryBean;
            resultDirectoryInternalBean.setUsers(this.usersService.setUsers(resultDirectoryInternalBean.getId(), directoryInternalBean.getUsers()));
        }
        return resultDirectoryBean;
    }

    @Override
    public void deleteDirectories(boolean force) {
        if (!force) {
            throw new BadRequestException("'force = true' must be supplied to delete all entries");
        }
        Collection<Directory> directories = this.findAllDirectories();
        directories.stream().sorted(new DirectoryComparator()).limit((long)directories.size() - 1L).forEach(d -> this.deleteDirectory(d.getId()));
    }

    @Override
    public void deleteDirectory(long id) {
        if (this.findAllDirectories().size() <= 1) {
            throw new BadRequestException("Cannot delete directory '%s' as this is the last remaining directory");
        }
        Directory directory = this.findDirectory(id);
        try {
            this.directoryManager.removeDirectory(directory);
        }
        catch (DirectoryNotFoundException e) {
            throw new InternalServerErrorException(String.format("When trying to delete directory '%s', it could not be found anymore", directory.getName()));
        }
        catch (DirectoryCurrentlySynchronisingException e) {
            throw new ServiceUnavailableException(e, (Integer)5);
        }
    }

    @Nonnull
    Directory findDirectory(long id) {
        try {
            return this.directoryManager.findDirectoryById(id);
        }
        catch (DirectoryNotFoundException e) {
            throw new NotFoundExceptionForDirectory(id);
        }
    }

    @Nonnull
    Collection<Directory> findAllDirectories() {
        EntityQuery allDirectoriesEntityQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1);
        return this.directoryManager.searchDirectories(allDirectoriesEntityQuery);
    }

    static class DirectoryComparator
    implements Comparator<Directory> {
        DirectoryComparator() {
        }

        @Override
        public int compare(Directory d1, Directory d2) {
            if (d1.getType().equals((Object)DirectoryType.INTERNAL) && !d2.getType().equals((Object)DirectoryType.INTERNAL)) {
                return 1;
            }
            if (!d1.getType().equals((Object)DirectoryType.INTERNAL) && d2.getType().equals((Object)DirectoryType.INTERNAL)) {
                return -1;
            }
            return d2.getCreatedDate().compareTo(d1.getCreatedDate());
        }
    }
}

