/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.model.util;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import de.aservo.confapi.commons.model.ApplicationLinkBean;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.NotImplementedException;

public class ApplicationLinkBeanUtil {
    @NotNull
    public static ApplicationLinkBean toApplicationLinkBean(@NotNull ApplicationLink linkDetails) {
        ApplicationLinkBean applicationLinkBean = new ApplicationLinkBean();
        applicationLinkBean.setUuid(UUID.fromString(linkDetails.getId().get()));
        applicationLinkBean.setName(linkDetails.getName());
        applicationLinkBean.setType(ApplicationLinkBeanUtil.getLinkTypeFromAppType(linkDetails.getType()));
        applicationLinkBean.setDisplayUrl(linkDetails.getDisplayUrl());
        applicationLinkBean.setRpcUrl(linkDetails.getRpcUrl());
        applicationLinkBean.setPrimary(linkDetails.isPrimary());
        return applicationLinkBean;
    }

    @NotNull
    public static ApplicationLinkDetails toApplicationLinkDetails(@NotNull ApplicationLinkBean applicationLinkBean) {
        return ApplicationLinkDetails.builder().name(applicationLinkBean.getName()).displayUrl(applicationLinkBean.getDisplayUrl()).rpcUrl(applicationLinkBean.getRpcUrl()).isPrimary(applicationLinkBean.isPrimary()).build();
    }

    private static ApplicationLinkBean.ApplicationLinkType getLinkTypeFromAppType(@NotNull ApplicationType type) {
        if (type instanceof BambooApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.BAMBOO;
        }
        if (type instanceof JiraApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.JIRA;
        }
        if (type instanceof BitbucketApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.BITBUCKET;
        }
        if (type instanceof ConfluenceApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.CONFLUENCE;
        }
        if (type instanceof FishEyeCrucibleApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.FISHEYE;
        }
        if (type instanceof CrowdApplicationType) {
            return ApplicationLinkBean.ApplicationLinkType.CROWD;
        }
        throw new NotImplementedException("application type '" + type.getClass() + "' not implemented");
    }

    private ApplicationLinkBeanUtil() {
    }
}

