/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.model.util;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoryCrowdBean;
import de.aservo.confapi.commons.model.DirectoryGenericBean;
import de.aservo.confapi.commons.model.DirectoryInternalBean;
import de.aservo.confapi.commons.model.DirectoryLdapBean;
import de.aservo.confapi.commons.util.ConversionUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class DirectoryBeanUtil {
    @NotNull
    public static Directory toDirectory(@NotNull DirectoryCrowdBean directoryBean) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (directoryBean.getServer() != null) {
            if (directoryBean.getServer().getUrl() != null) {
                attributes.put("crowd.server.url", directoryBean.getServer().getUrl().toString());
            }
            attributes.put("application.name", directoryBean.getServer().getAppUsername());
            attributes.put("application.password", directoryBean.getServer().getAppPassword());
            if (directoryBean.getServer().getProxy() != null) {
                attributes.put("crowd.server.http.proxy.host", directoryBean.getServer().getProxy().getHost());
                if (directoryBean.getServer().getProxy().getPort() != null) {
                    attributes.put("crowd.server.http.proxy.port", directoryBean.getServer().getProxy().getPort().toString());
                }
                attributes.put("crowd.server.http.proxy.username", directoryBean.getServer().getProxy().getUsername());
                attributes.put("crowd.server.http.proxy.password", directoryBean.getServer().getProxy().getPassword());
            }
        }
        if (directoryBean.getAdvanced() != null) {
            attributes.put("directory.cache.synchronise.interval", directoryBean.getAdvanced().getUpdateSyncIntervalInMinutes() != 0 ? String.valueOf(directoryBean.getAdvanced().getUpdateSyncIntervalInMinutes()) : "3600");
            attributes.put("useNestedGroups", String.valueOf(directoryBean.getAdvanced().getEnableNestedGroups()));
            attributes.put("crowd.sync.incremental.enabled", String.valueOf(directoryBean.getAdvanced().getEnableIncrementalSync()));
            attributes.put("crowd.sync.group.membership.after.successful.user.auth.enabled", directoryBean.getAdvanced().getUpdateGroupMembershipMethod());
        }
        return ImmutableDirectory.builder((String)directoryBean.getName(), (DirectoryType)DirectoryBeanUtil.getDirectoryType(directoryBean), (String)RemoteCrowdDirectory.class.getName()).setActive(directoryBean.getActive() != null && directoryBean.getActive() != false).setAttributes(attributes).build();
    }

    @NotNull
    public static AbstractDirectoryBean toDirectoryBean(@NotNull Directory directory) {
        AbstractDirectoryBean directoryBean;
        Map attributes = directory.getAttributes();
        if (DirectoryType.CROWD.equals((Object)directory.getType())) {
            DirectoryCrowdBean.DirectoryCrowdServer serverBean = new DirectoryCrowdBean.DirectoryCrowdServer();
            serverBean.setUrl(URI.create((String)attributes.get("crowd.server.url")));
            if (attributes.containsKey("crowd.server.http.proxy.host")) {
                DirectoryCrowdBean.DirectoryCrowdServer.DirectoryCrowdServerProxy proxy = new DirectoryCrowdBean.DirectoryCrowdServer.DirectoryCrowdServerProxy();
                proxy.setUsername((String)attributes.get("crowd.server.http.proxy.username"));
                proxy.setHost((String)attributes.get("crowd.server.http.proxy.host"));
                if (attributes.get("crowd.server.http.proxy.port") != null) {
                    proxy.setPort(Integer.valueOf((String)attributes.get("crowd.server.http.proxy.port")));
                }
                serverBean.setProxy(proxy);
            }
            serverBean.setConnectionTimeoutInMillis(ConversionUtil.toLong((String)attributes.get("crowd.server.http.timeout")));
            serverBean.setMaxConnections(ConversionUtil.toInt((String)attributes.get("crowd.server.http.max.connections")));
            serverBean.setAppUsername((String)attributes.get("application.name"));
            DirectoryCrowdBean.DirectoryCrowdAdvanced advanced = new DirectoryCrowdBean.DirectoryCrowdAdvanced();
            advanced.setEnableIncrementalSync(ConversionUtil.toBoolean((String)attributes.get("crowd.sync.incremental.enabled")));
            advanced.setEnableNestedGroups(ConversionUtil.toBoolean((String)attributes.get("useNestedGroups")));
            advanced.setUpdateSyncIntervalInMinutes(ConversionUtil.toInt((String)attributes.get("directory.cache.synchronise.interval")));
            DirectoryCrowdBean directoryCrowdBean = new DirectoryCrowdBean();
            directoryCrowdBean.setServer(serverBean);
            directoryCrowdBean.setAdvanced(advanced);
            directoryBean = directoryCrowdBean;
        } else {
            directoryBean = new DirectoryGenericBean();
        }
        directoryBean.setName(directory.getName());
        directoryBean.setActive(directory.isActive());
        directoryBean.setDescription(directory.getDescription());
        directoryBean.setId(directory.getId());
        return directoryBean;
    }

    public static DirectoryType getDirectoryType(@NotNull AbstractDirectoryBean directoryBean) {
        if (directoryBean instanceof DirectoryInternalBean) {
            return DirectoryType.INTERNAL;
        }
        if (directoryBean instanceof DirectoryCrowdBean) {
            return DirectoryType.CROWD;
        }
        if (directoryBean instanceof DirectoryLdapBean) {
            return DirectoryType.DELEGATING;
        }
        return DirectoryType.UNKNOWN;
    }

    private DirectoryBeanUtil() {
    }
}

