/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.core.ApplinkStatus;
import com.atlassian.applinks.core.ApplinkStatusService;
import com.atlassian.applinks.internal.common.exception.NoAccessException;
import com.atlassian.applinks.internal.common.exception.NoSuchApplinkException;
import com.atlassian.applinks.internal.status.error.ApplinkErrorType;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.model.ApplicationLinkBean;
import de.aservo.confapi.commons.model.ApplicationLinksBean;
import de.aservo.confapi.commons.service.api.ApplicationLinksService;
import de.aservo.confapi.jira.model.type.DefaultAuthenticationScenario;
import de.aservo.confapi.jira.model.util.ApplicationLinkBeanUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ApplicationLinksService.class})
public class ApplicationLinkServiceImpl
implements ApplicationLinksService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkServiceImpl.class);
    private final MutatingApplicationLinkService mutatingApplicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ApplinkStatusService applinkStatusService;

    @Inject
    public ApplicationLinkServiceImpl(@ComponentImport MutatingApplicationLinkService mutatingApplicationLinkService, @ComponentImport TypeAccessor typeAccessor, @ComponentImport ApplinkStatusService applinkStatusService) {
        this.mutatingApplicationLinkService = mutatingApplicationLinkService;
        this.typeAccessor = typeAccessor;
        this.applinkStatusService = applinkStatusService;
    }

    @Override
    public ApplicationLinksBean getApplicationLinks() {
        Iterable applicationLinksIterable = this.mutatingApplicationLinkService.getApplicationLinks();
        List<ApplicationLinkBean> applicationLinkBeans = StreamSupport.stream(applicationLinksIterable.spliterator(), false).map(this::getApplicationLinkBeanWithStatus).collect(Collectors.toList());
        return new ApplicationLinksBean(applicationLinkBeans);
    }

    @Override
    public ApplicationLinkBean getApplicationLink(UUID uuid) {
        ApplicationId id = new ApplicationId(uuid.toString());
        try {
            MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.getApplicationLink(id);
            return this.getApplicationLinkBeanWithStatus((ApplicationLink)applicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @Override
    public ApplicationLinksBean setApplicationLinks(ApplicationLinksBean applicationLinksBean, boolean ignoreSetupErrors) {
        Map<URI, ApplicationLinkBean> linkBeanMap = this.getApplicationLinks().getApplicationLinks().stream().collect(Collectors.toMap(ApplicationLinkBean::getRpcUrl, link -> link));
        for (ApplicationLinkBean applicationLink : applicationLinksBean.getApplicationLinks()) {
            URI key = applicationLink.getRpcUrl();
            if (linkBeanMap.containsKey(key)) {
                this.setApplicationLink(linkBeanMap.get(key).getUuid(), applicationLink, ignoreSetupErrors);
                continue;
            }
            this.addApplicationLink(applicationLink, ignoreSetupErrors);
        }
        return this.getApplicationLinks();
    }

    @Override
    public ApplicationLinkBean setApplicationLink(UUID uuid, ApplicationLinkBean applicationLinkBean, boolean ignoreSetupErrors) {
        ApplicationId id = new ApplicationId(uuid.toString());
        try {
            MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.getApplicationLink(id);
            ApplicationType applicationType = this.buildApplicationType(applicationLinkBean.getType());
            ApplicationLinkDetails linkDetails = ApplicationLinkBeanUtil.toApplicationLinkDetails(applicationLinkBean);
            if (applicationLink.getType().equals(applicationType) && applicationLinkBean.getPassword() == null && applicationLinkBean.getUsername() == null) {
                applicationLink.update(linkDetails);
                return this.getApplicationLinkBeanWithStatus((ApplicationLink)applicationLink);
            }
            this.mutatingApplicationLinkService.deleteApplicationLink((ApplicationLink)applicationLink);
            MutableApplicationLink mutableApplicationLink = this.mutatingApplicationLinkService.addApplicationLink(id, applicationType, linkDetails);
            return this.getApplicationLinkBeanWithStatus((ApplicationLink)mutableApplicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @Override
    public ApplicationLinkBean addApplicationLink(ApplicationLinkBean linkBean, boolean ignoreSetupErrors) {
        ApplicationLink applicationLink;
        block5: {
            ApplicationLinkDetails linkDetails = ApplicationLinkBeanUtil.toApplicationLinkDetails(linkBean);
            ApplicationType applicationType = this.buildApplicationType(linkBean.getType());
            Class<?> appType = applicationType != null ? applicationType.getClass() : null;
            ApplicationLink primaryApplicationLink = this.mutatingApplicationLinkService.getPrimaryApplicationLink(appType);
            if (primaryApplicationLink != null) {
                log.info("An existiaang application link configuration '{}' was found and is removed now before adding the new configuration", (Object)primaryApplicationLink.getName());
                this.mutatingApplicationLinkService.deleteApplicationLink(primaryApplicationLink);
            }
            try {
                applicationLink = this.mutatingApplicationLinkService.createApplicationLink(applicationType, linkDetails);
            }
            catch (ManifestNotFoundException e) {
                throw new BadRequestException(e.getMessage());
            }
            try {
                this.mutatingApplicationLinkService.configureAuthenticationForApplicationLink(applicationLink, (AuthenticationScenario)new DefaultAuthenticationScenario(), linkBean.getUsername(), linkBean.getPassword());
            }
            catch (AuthenticationConfigurationException e) {
                if (ignoreSetupErrors) break block5;
                throw new BadRequestException(e.getMessage());
            }
        }
        return this.getApplicationLinkBeanWithStatus(applicationLink);
    }

    @Override
    public void deleteApplicationLinks(boolean force) {
        if (!force) {
            throw new BadRequestException("'force = true' must be supplied to delete all entries");
        }
        for (ApplicationLink applicationLink : this.mutatingApplicationLinkService.getApplicationLinks()) {
            this.mutatingApplicationLinkService.deleteApplicationLink(applicationLink);
        }
    }

    @Override
    public void deleteApplicationLink(UUID id) {
        ApplicationId applicationId = new ApplicationId(String.valueOf(id));
        try {
            MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.getApplicationLink(applicationId);
            this.mutatingApplicationLinkService.deleteApplicationLink((ApplicationLink)applicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    protected ApplicationType buildApplicationType(ApplicationLinkBean.ApplicationLinkType linkType) {
        switch (linkType) {
            case BAMBOO: {
                return this.typeAccessor.getApplicationType(BambooApplicationType.class);
            }
            case JIRA: {
                return this.typeAccessor.getApplicationType(JiraApplicationType.class);
            }
            case BITBUCKET: {
                return this.typeAccessor.getApplicationType(BitbucketApplicationType.class);
            }
            case CONFLUENCE: {
                return this.typeAccessor.getApplicationType(ConfluenceApplicationType.class);
            }
            case FISHEYE: {
                return this.typeAccessor.getApplicationType(FishEyeCrucibleApplicationType.class);
            }
            case CROWD: {
                return this.typeAccessor.getApplicationType(CrowdApplicationType.class);
            }
        }
        throw new NotImplementedException("application type '" + (Object)((Object)linkType) + "' not implemented");
    }

    private ApplicationLinkBean getApplicationLinkBeanWithStatus(ApplicationLink applicationLink) {
        ApplicationLinkBean applicationLinkBean = ApplicationLinkBeanUtil.toApplicationLinkBean(applicationLink);
        try {
            ApplinkStatus applinkStatus = this.applinkStatusService.getApplinkStatus(applicationLink.getId());
            if (applinkStatus.isWorking()) {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.AVAILABLE);
            } else if (applinkStatus.getError() != null && ApplinkErrorType.CONNECTION_REFUSED.equals((Object)applinkStatus.getError().getType())) {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.UNAVAILABLE);
            } else {
                applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.CONFIGURATION_ERROR);
            }
        }
        catch (NoAccessException | NoSuchApplinkException e) {
            applicationLinkBean.setStatus(ApplicationLinkBean.ApplicationLinkStatus.CONFIGURATION_ERROR);
        }
        return applicationLinkBean;
    }
}

