/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.commons.exception.ServiceUnavailableException;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoriesBean;
import de.aservo.confapi.commons.model.DirectoryCrowdBean;
import de.aservo.confapi.commons.service.api.DirectoriesService;
import de.aservo.confapi.jira.model.util.DirectoryBeanUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={DirectoriesService.class})
public class DirectoryServiceImpl
implements DirectoriesService {
    private static final Logger log = LoggerFactory.getLogger(DirectoryServiceImpl.class);
    public static final int RETRY_AFTER_IN_SECONDS = 5;
    private final CrowdDirectoryService crowdDirectoryService;

    @Inject
    public DirectoryServiceImpl(@ComponentImport CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = (CrowdDirectoryService)Preconditions.checkNotNull((Object)crowdDirectoryService);
    }

    @Override
    public DirectoriesBean getDirectories() {
        ArrayList<AbstractDirectoryBean> beans = new ArrayList<AbstractDirectoryBean>();
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            AbstractDirectoryBean crowdBean = DirectoryBeanUtil.toDirectoryBean(directory);
            beans.add(crowdBean);
        }
        return new DirectoriesBean(beans);
    }

    @Override
    public AbstractDirectoryBean getDirectory(long id) {
        Directory directory = this.findDirectory(id);
        return DirectoryBeanUtil.toDirectoryBean(directory);
    }

    @Override
    public DirectoriesBean setDirectories(DirectoriesBean directoriesBean, boolean testConnection) {
        Map existingDirectoriesByName = this.crowdDirectoryService.findAllDirectories().stream().collect(Collectors.toMap(Directory::getName, Function.identity()));
        directoriesBean.getDirectories().forEach(directoryRequestBean -> {
            if (directoryRequestBean instanceof DirectoryCrowdBean) {
                DirectoryCrowdBean crowdRequestBean = (DirectoryCrowdBean)directoryRequestBean;
                if (existingDirectoriesByName.containsKey(crowdRequestBean.getName())) {
                    this.setDirectory(((Directory)existingDirectoriesByName.get(crowdRequestBean.getName())).getId(), crowdRequestBean, testConnection);
                } else {
                    this.addDirectory(crowdRequestBean, testConnection);
                }
            } else {
                throw new BadRequestException(String.format("Updating directory type '%s' is not supported (yet)", directoryRequestBean.getClass()));
            }
        });
        return this.getDirectories();
    }

    @Override
    public AbstractDirectoryBean setDirectory(long id, @NotNull AbstractDirectoryBean abstractDirectoryBean, boolean testConnection) {
        if (abstractDirectoryBean instanceof DirectoryCrowdBean) {
            return this.setDirectoryCrowd(id, (DirectoryCrowdBean)abstractDirectoryBean, testConnection);
        }
        throw new BadRequestException(String.format("Setting directory type '%s' is not supported (yet)", abstractDirectoryBean.getClass()));
    }

    private AbstractDirectoryBean setDirectoryCrowd(long id, @NotNull DirectoryCrowdBean crowdBean, boolean testConnection) {
        Directory existingDirectory = this.findDirectory(id);
        Directory directory = this.validateAndCreateDirectoryConfig(crowdBean, testConnection);
        ImmutableDirectory.Builder directoryBuilder = ImmutableDirectory.newBuilder((Directory)existingDirectory);
        directoryBuilder.setAttributes(directory.getAttributes());
        directoryBuilder.setDescription(directory.getDescription());
        directoryBuilder.setName(directory.getName());
        directoryBuilder.setActive(directory.isActive());
        Directory updatedDirectory = directoryBuilder.toDirectory();
        Directory responseDirectory = this.crowdDirectoryService.updateDirectory(updatedDirectory);
        return DirectoryBeanUtil.toDirectoryBean(responseDirectory);
    }

    @Override
    public AbstractDirectoryBean addDirectory(AbstractDirectoryBean abstractDirectoryBean, boolean testConnection) {
        if (abstractDirectoryBean instanceof DirectoryCrowdBean) {
            DirectoryCrowdBean crowdBean = (DirectoryCrowdBean)abstractDirectoryBean;
            Directory directory = this.validateAndCreateDirectoryConfig(crowdBean, testConnection);
            Directory addedDirectory = this.crowdDirectoryService.addDirectory(directory);
            return DirectoryBeanUtil.toDirectoryBean(addedDirectory);
        }
        throw new BadRequestException(String.format("Adding directory type '%s' is not supported (yet)", abstractDirectoryBean.getClass()));
    }

    @Override
    public void deleteDirectories(boolean force) {
        if (!force) {
            throw new BadRequestException("'force = true' must be supplied to delete all entries");
        }
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (DirectoryType.INTERNAL.equals((Object)directory.getType())) continue;
            this.deleteDirectory(directory.getId());
        }
    }

    @Override
    public void deleteDirectory(long id) {
        this.findDirectory(id);
        try {
            this.crowdDirectoryService.removeDirectory(id);
        }
        catch (DirectoryCurrentlySynchronisingException e) {
            throw new ServiceUnavailableException(e, (Integer)5);
        }
    }

    private Directory findDirectory(long id) {
        Directory directory = this.crowdDirectoryService.findDirectoryById(id);
        if (directory == null) {
            throw new NotFoundException(String.format("directory with id '%s' was not found!", id));
        }
        return directory;
    }

    private Directory validateAndCreateDirectoryConfig(DirectoryCrowdBean crowdBean, boolean testConnection) {
        Directory directory = DirectoryBeanUtil.toDirectory(crowdBean);
        String directoryName = crowdBean.getName();
        if (testConnection) {
            log.debug("testing user directory connection for {}", (Object)directoryName);
            this.crowdDirectoryService.testConnection(directory);
        }
        return directory;
    }
}

