/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.model.LicenseBean;
import de.aservo.confapi.commons.model.LicensesBean;
import de.aservo.confapi.commons.service.api.LicensesService;
import de.aservo.confapi.jira.model.util.LicenseBeanUtil;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LicensesService.class})
public class LicensesServiceImpl
implements LicensesService {
    private final JiraLicenseManager licenseManager;

    @Inject
    public LicensesServiceImpl(@ComponentImport JiraLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public LicensesBean getLicenses() {
        ArrayList<LicenseBean> licenseBeans = new ArrayList<LicenseBean>();
        for (LicenseDetails licenseDetails : this.licenseManager.getLicenses()) {
            licenseBeans.add(LicenseBeanUtil.toLicenseBean(licenseDetails));
        }
        return new LicensesBean(licenseBeans);
    }

    public LicensesBean setLicenses(@NotNull LicensesBean licensesBean) {
        this.licenseManager.removeLicenses(this.licenseManager.getLicenses());
        licensesBean.getLicenses().stream().map(LicenseBean::getKey).forEach(arg_0 -> ((JiraLicenseManager)this.licenseManager).setLicense(arg_0));
        return this.getLicenses();
    }

    @Override
    public LicenseBean addLicense(@NotNull LicenseBean licenseBean) {
        return LicenseBeanUtil.toLicenseBean(this.licenseManager.setLicense(licenseBean.getKey()));
    }
}

