/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.model.MailServerPopBean;
import de.aservo.confapi.commons.model.MailServerSmtpBean;
import de.aservo.confapi.commons.service.api.MailServerService;
import de.aservo.confapi.jira.model.util.MailServerPopBeanUtil;
import de.aservo.confapi.jira.model.util.MailServerSmtpBeanUtil;
import de.aservo.confapi.jira.util.MailProtocolUtil;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={MailServerService.class})
public class MailServerServiceImpl
implements MailServerService {
    private final MailServerManager mailServerManager;

    @Inject
    public MailServerServiceImpl(@ComponentImport MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Override
    public MailServerSmtpBean getMailServerSmtp() {
        SMTPMailServer smtpMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        return MailServerSmtpBeanUtil.toMailServerSmtpBean(smtpMailServer);
    }

    @Override
    public MailServerSmtpBean setMailServerSmtp(@NotNull MailServerSmtpBean mailServerSmtpBean) {
        SMTPMailServerImpl smtpMailServer;
        Object object = smtpMailServer = this.mailServerManager.isDefaultSMTPMailServerDefined() ? this.mailServerManager.getDefaultSMTPMailServer() : new SMTPMailServerImpl();
        assert (smtpMailServer != null);
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getName())) {
            smtpMailServer.setName(mailServerSmtpBean.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getDescription())) {
            smtpMailServer.setDescription(mailServerSmtpBean.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getFrom())) {
            smtpMailServer.setDefaultFrom(mailServerSmtpBean.getFrom());
        }
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getPrefix())) {
            smtpMailServer.setPrefix(mailServerSmtpBean.getPrefix());
        }
        smtpMailServer.setMailProtocol(MailProtocolUtil.find(mailServerSmtpBean.getProtocol(), MailProtocol.SMTP));
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getHost())) {
            smtpMailServer.setHostname(mailServerSmtpBean.getHost());
        }
        if (mailServerSmtpBean.getPort() != null) {
            smtpMailServer.setPort(String.valueOf(mailServerSmtpBean.getPort()));
        } else {
            smtpMailServer.setPort(smtpMailServer.getMailProtocol().getDefaultPort());
        }
        smtpMailServer.setTlsRequired(mailServerSmtpBean.getUseTls());
        if (StringUtils.isNotBlank((CharSequence)mailServerSmtpBean.getUsername())) {
            smtpMailServer.setUsername(mailServerSmtpBean.getUsername());
        }
        smtpMailServer.setTimeout(mailServerSmtpBean.getTimeout().longValue());
        try {
            if (this.mailServerManager.isDefaultSMTPMailServerDefined()) {
                this.mailServerManager.update((MailServer)smtpMailServer);
            } else {
                smtpMailServer.setId(this.mailServerManager.create((MailServer)smtpMailServer));
            }
        }
        catch (MailException e) {
            throw new BadRequestException(e.getMessage());
        }
        return mailServerSmtpBean;
    }

    @Override
    public MailServerPopBean getMailServerPop() {
        PopMailServer popMailServer = this.mailServerManager.getDefaultPopMailServer();
        return MailServerPopBeanUtil.toMailServerPopBean(popMailServer);
    }

    @Override
    public MailServerPopBean setMailServerPop(@NotNull MailServerPopBean mailServerPopBean) {
        PopMailServerImpl popMailServer;
        Object object = popMailServer = this.mailServerManager.getDefaultPopMailServer() != null ? this.mailServerManager.getDefaultPopMailServer() : new PopMailServerImpl();
        assert (popMailServer != null);
        if (StringUtils.isNotBlank((CharSequence)mailServerPopBean.getName())) {
            popMailServer.setName(mailServerPopBean.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)mailServerPopBean.getDescription())) {
            popMailServer.setDescription(mailServerPopBean.getDescription());
        }
        popMailServer.setMailProtocol(MailProtocolUtil.find(mailServerPopBean.getProtocol(), MailProtocol.POP));
        if (StringUtils.isNotBlank((CharSequence)mailServerPopBean.getHost())) {
            popMailServer.setHostname(mailServerPopBean.getHost());
        }
        if (mailServerPopBean.getPort() != null) {
            popMailServer.setPort(String.valueOf(mailServerPopBean.getPort()));
        } else {
            popMailServer.setPort(popMailServer.getMailProtocol().getDefaultPort());
        }
        if (StringUtils.isNotBlank((CharSequence)mailServerPopBean.getUsername())) {
            popMailServer.setUsername(mailServerPopBean.getUsername());
        }
        popMailServer.setTimeout(mailServerPopBean.getTimeout().longValue());
        try {
            if (this.mailServerManager.getDefaultPopMailServer() != null) {
                this.mailServerManager.update((MailServer)popMailServer);
            } else {
                popMailServer.setId(this.mailServerManager.create((MailServer)popMailServer));
            }
        }
        catch (MailException e) {
            throw new BadRequestException(e.getMessage());
        }
        return mailServerPopBean;
    }
}

