/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.lookandfeel.ImageScaler;
import com.atlassian.jira.lookandfeel.LogoChoice;
import com.atlassian.jira.lookandfeel.LookAndFeelProperties;
import com.atlassian.jira.lookandfeel.upload.LogoUploader;
import com.atlassian.jira.lookandfeel.upload.UploadService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Suppliers;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.model.SettingsBrandingColorSchemeBean;
import de.aservo.confapi.commons.service.api.SettingsBrandingService;
import de.aservo.confapi.jira.model.util.SettingsBrandingColorSchemeBeanUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SettingsBrandingService.class})
public class SettingsBrandingServiceImpl
implements SettingsBrandingService {
    private final ApplicationProperties applicationProperties;
    private final UploadService uploadService;
    private final JiraHome jiraHome;
    private final JiraAuthenticationContext authenticationContext;
    private final PluginSettings globalSettings;
    private final Supplier<LookAndFeelBean> lookAndFeelBeanSupplier;
    private final LookAndFeelProperties lookAndFeelProperties;

    @Inject
    public SettingsBrandingServiceImpl(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport JiraHome jiraHome, @ComponentImport PluginSettingsFactory globalSettingsFactory, @ComponentImport LookAndFeelProperties lookAndFeelProperties, @ComponentImport UploadService uploadService) {
        this.applicationProperties = applicationProperties;
        this.uploadService = uploadService;
        this.jiraHome = jiraHome;
        this.authenticationContext = authenticationContext;
        this.globalSettings = globalSettingsFactory.createGlobalSettings();
        this.lookAndFeelBeanSupplier = Suppliers.memoize(() -> LookAndFeelBean.getInstance((ApplicationProperties)applicationProperties));
        this.lookAndFeelProperties = lookAndFeelProperties;
    }

    @Override
    public SettingsBrandingColorSchemeBean getColourScheme() {
        return SettingsBrandingColorSchemeBeanUtil.getSettingsBrandingColorSchemeBean(this.applicationProperties);
    }

    @Override
    public SettingsBrandingColorSchemeBean setColourScheme(@NotNull SettingsBrandingColorSchemeBean colorSchemeBean) {
        SettingsBrandingColorSchemeBeanUtil.setGlobalColorScheme(colorSchemeBean, false, this.applicationProperties);
        return SettingsBrandingColorSchemeBeanUtil.getSettingsBrandingColorSchemeBean(this.applicationProperties);
    }

    @Override
    public InputStream getLogo() {
        return this.getLogoStream("jira-logo-scaled.png");
    }

    @Override
    public void setLogo(@NotNull InputStream inputStream) {
        ImageScaler imageScaler = new ImageScaler();
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, imageScaler, this.authenticationContext.getI18nHelper(), this.uploadService);
        String logoUrl = logoUploader.saveLogo(inputStream, "jira-logo-original.png", "jira-logo-scaled.png");
        LookAndFeelBean lfb = this.lookAndFeelBeanSupplier.get();
        lfb.setLogoWidth(Integer.toString(logoUploader.getResizedWidth()));
        lfb.setLogoHeight(Integer.toString(logoUploader.getResizedHeight()));
        lfb.setLogoUrl(this.ensureUrlCorrect(logoUrl));
        this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomLogo", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        this.lookAndFeelProperties.setLogoChoice(LogoChoice.UPLOAD);
    }

    @Override
    public InputStream getFavicon() {
        return this.getLogoStream("jira-favicon-scaled.png");
    }

    @Override
    public void setFavicon(@NotNull InputStream inputStream) {
        ImageScaler imageScaler = new ImageScaler();
        LogoUploader logoUploader = new LogoUploader(this.applicationProperties, this.jiraHome, imageScaler, this.authenticationContext.getI18nHelper(), this.uploadService);
        String faviconUrl = logoUploader.saveFavicon(inputStream, "jira-favicon-original.png", "jira-favicon-hires.png", "jira-favicon-scaled.png", "jira-favicon-scaled.ico");
        LookAndFeelBean lfb = this.lookAndFeelBeanSupplier.get();
        lfb.setFaviconUrl(this.ensureUrlCorrect(faviconUrl));
        lfb.setFaviconHiResUrl("/jira-favicon-hires.png");
        this.globalSettings.put("com.atlassian.jira.lookandfeel:usingCustomFavicon", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        this.lookAndFeelProperties.setFaviconChoice(LogoChoice.UPLOAD);
    }

    private String ensureUrlCorrect(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && !url.startsWith("http") && !url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }

    private FileInputStream getLogoStream(String key) {
        File logoDirectory = this.uploadService.getLogoDirectory();
        try {
            return new FileInputStream(new File(logoDirectory, key));
        }
        catch (FileNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }
}

