/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.jira.service;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.model.SettingsBean;
import de.aservo.confapi.commons.service.api.SettingsService;
import java.net.URI;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SettingsService.class})
public class SettingsServiceImpl
implements SettingsService {
    private final ApplicationProperties applicationProperties;

    @Inject
    public SettingsServiceImpl(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public SettingsBean getSettings() {
        SettingsBean settingsBean = new SettingsBean();
        String baseUrl = this.applicationProperties.getString("jira.baseurl");
        if (baseUrl != null) {
            settingsBean.setBaseUrl(URI.create(baseUrl));
        }
        settingsBean.setMode(this.applicationProperties.getString("jira.mode"));
        settingsBean.setTitle(this.applicationProperties.getString("jira.title"));
        settingsBean.setContactMessage(this.applicationProperties.getString("jira.contact.administrators.message"));
        settingsBean.setExternalUserManagement(Boolean.parseBoolean(this.applicationProperties.getString("jira.option.user.externalmanagement")));
        return settingsBean;
    }

    @Override
    public SettingsBean setSettings(SettingsBean settingsBean) {
        if (settingsBean.getBaseUrl() != null) {
            this.applicationProperties.setString("jira.baseurl", settingsBean.getBaseUrl().toString());
        }
        if (settingsBean.getMode() != null) {
            if (!settingsBean.getMode().equalsIgnoreCase("public") && !settingsBean.getMode().equalsIgnoreCase("private")) {
                throw new BadRequestException("Mode '" + settingsBean.getMode() + "' is not supported");
            }
            if (settingsBean.getMode().equalsIgnoreCase("public") && this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
                throw new BadRequestException("Mode '" + settingsBean.getMode() + "' cannot be set with external user management");
            }
            this.applicationProperties.setString("jira.mode", settingsBean.getMode());
        }
        if (settingsBean.getTitle() != null) {
            this.applicationProperties.setString("jira.title", settingsBean.getTitle());
        }
        if (settingsBean.getContactMessage() != null) {
            this.applicationProperties.setString("jira.contact.administrators.message", settingsBean.getContactMessage());
        }
        if (settingsBean.getExternalUserManagement() != null) {
            this.applicationProperties.setString("jira.option.user.externalmanagement", String.valueOf(settingsBean.getExternalUserManagement()));
        }
        return this.getSettings();
    }
}

