/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import de.bausdorf.simracing.irdataapi.client.AuthorizationException;
import de.bausdorf.simracing.irdataapi.client.CategoryType;
import de.bausdorf.simracing.irdataapi.client.ChartType;
import de.bausdorf.simracing.irdataapi.client.DataApiException;
import de.bausdorf.simracing.irdataapi.client.IrDataClient;
import de.bausdorf.simracing.irdataapi.client.LookupTypes;
import de.bausdorf.simracing.irdataapi.client.impl.IRacingObjectMapper;
import de.bausdorf.simracing.irdataapi.model.AuthResponseDto;
import de.bausdorf.simracing.irdataapi.model.CarAssetDto;
import de.bausdorf.simracing.irdataapi.model.CarClassDto;
import de.bausdorf.simracing.irdataapi.model.CarInfoDto;
import de.bausdorf.simracing.irdataapi.model.ChunkInfoDto;
import de.bausdorf.simracing.irdataapi.model.ConstantDto;
import de.bausdorf.simracing.irdataapi.model.CustLeagueSessionsDto;
import de.bausdorf.simracing.irdataapi.model.DriverQualifyStandingDto;
import de.bausdorf.simracing.irdataapi.model.DriverStandingDto;
import de.bausdorf.simracing.irdataapi.model.DriverStandingsDto;
import de.bausdorf.simracing.irdataapi.model.DriverTtStandingDto;
import de.bausdorf.simracing.irdataapi.model.EventLogDto;
import de.bausdorf.simracing.irdataapi.model.EventLogEntryDto;
import de.bausdorf.simracing.irdataapi.model.LapChartDto;
import de.bausdorf.simracing.irdataapi.model.LapChartEntryDto;
import de.bausdorf.simracing.irdataapi.model.LapDataDto;
import de.bausdorf.simracing.irdataapi.model.LeagueDirectoryDto;
import de.bausdorf.simracing.irdataapi.model.LeagueInfoDto;
import de.bausdorf.simracing.irdataapi.model.LeaguePointSystemsDto;
import de.bausdorf.simracing.irdataapi.model.LeagueSeasonSessionsDto;
import de.bausdorf.simracing.irdataapi.model.LeagueSeasonsDto;
import de.bausdorf.simracing.irdataapi.model.LicenseGroupDto;
import de.bausdorf.simracing.irdataapi.model.LinkResponseDto;
import de.bausdorf.simracing.irdataapi.model.LoginRequestDto;
import de.bausdorf.simracing.irdataapi.model.LookupDto;
import de.bausdorf.simracing.irdataapi.model.MemberCareerDto;
import de.bausdorf.simracing.irdataapi.model.MemberChartDataDto;
import de.bausdorf.simracing.irdataapi.model.MemberDivisonDto;
import de.bausdorf.simracing.irdataapi.model.MemberRecentRacesDto;
import de.bausdorf.simracing.irdataapi.model.MemberSummaryDto;
import de.bausdorf.simracing.irdataapi.model.MemberYearlyDto;
import de.bausdorf.simracing.irdataapi.model.MembersInfoDto;
import de.bausdorf.simracing.irdataapi.model.SeasonDto;
import de.bausdorf.simracing.irdataapi.model.SeasonResultsDto;
import de.bausdorf.simracing.irdataapi.model.SeasonStandingsDto;
import de.bausdorf.simracing.irdataapi.model.SeriesAssetDto;
import de.bausdorf.simracing.irdataapi.model.SeriesDto;
import de.bausdorf.simracing.irdataapi.model.SeriesInfoDto;
import de.bausdorf.simracing.irdataapi.model.SubsessionResultDto;
import de.bausdorf.simracing.irdataapi.model.TeamInfoDto;
import de.bausdorf.simracing.irdataapi.model.TeamStandingDto;
import de.bausdorf.simracing.irdataapi.model.TrackAssetDto;
import de.bausdorf.simracing.irdataapi.model.TrackInfoDto;
import de.bausdorf.simracing.irdataapi.model.UserInfoDto;
import de.bausdorf.simracing.irdataapi.model.search.SearchRequestDto;
import de.bausdorf.simracing.irdataapi.tools.LoginHelper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class IrDataClientImpl
implements IrDataClient {
    private static final Logger log = LoggerFactory.getLogger(IrDataClientImpl.class);
    public static final String RETURNED_NULL_BODY = " returned null body";
    public static final String SUBSESSION_ID_URL_PARAM = "?subsession_id=";
    public static final String SIMSESSION_NUMBER_URL_PARAM = "&simsession_number=";
    public static final String SEASON_ID_URL_PARAM = "?season_id=";
    public static final String EVENT_TYPE_URL_PARAM = "&event_type=";
    public static final String RACE_WEEK_NUM_URL_PARAM = "&race_week_num=";
    public static final String CAR_CLASS_ID_URL_PARAM = "&car_class_id=";
    public static final String LEAGUE_ID_URL_PARAM = "?league_id=";
    public static final String SEASON_ID_URL_PARAM2 = "&season_id=";
    private final RestTemplate restTemplate;
    private final StatefulRestTemplateInterceptor restTemplateInterceptor;
    private final IRacingObjectMapper mapper;
    private AuthResponseDto authResponse;
    private boolean logResponseJson = false;
    private boolean hashPassword = true;
    private final Logger jsonLogger = LoggerFactory.getLogger((String)"JsonResponse");

    public IrDataClientImpl() {
        this.restTemplate = new RestTemplate();
        this.restTemplateInterceptor = new StatefulRestTemplateInterceptor();
        this.restTemplate.getInterceptors().add(this.restTemplateInterceptor);
        this.mapper = new IRacingObjectMapper();
        this.authResponse = null;
    }

    @Override
    public void setLogResponseJson(@NonNull Boolean logResponse) {
        this.logResponseJson = logResponse;
    }

    @Override
    public boolean isLogResponseJson() {
        return this.logResponseJson;
    }

    @Override
    public void setHashPassword(boolean hashPassword) {
        this.hashPassword = hashPassword;
    }

    @Override
    public boolean isHashPassword() {
        return this.hashPassword;
    }

    @Override
    public AuthResponseDto authenticate(@NonNull LoginRequestDto requestDto) {
        this.restTemplateInterceptor.flushCookies();
        ResponseEntity response = this.restTemplate.postForEntity("https://members-ng.iracing.com/auth", (Object)(this.hashPassword ? LoginHelper.hashPassword(requestDto) : requestDto), String.class, new Object[0]);
        try {
            String responseBody = (String)response.getBody();
            if (responseBody != null) {
                this.authResponse = (AuthResponseDto)this.mapper.readValue(responseBody, AuthResponseDto.class);
                if (this.authResponse.getAuthcode().equalsIgnoreCase("0")) {
                    throw new AuthorizationException(requestDto.getEmail() + " not authorized");
                }
            } else {
                throw new DataApiException("Null body when authenticating, status code " + response.getStatusCode());
            }
            log.info("iRacing DataApi authenticated for custId: {}", (Object)this.authResponse.getCustId());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.authResponse;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authResponse != null;
    }

    @Override
    public MembersInfoDto getMembersInfo(@NonNull List<Long> custIds) {
        StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/member/get");
        uri.append("?cust_ids=");
        for (int i = 0; i < custIds.size(); ++i) {
            uri.append(custIds.get(i));
            if (i >= custIds.size() - 1) continue;
            uri.append(',');
        }
        try {
            LinkResponseDto linkResponse = this.getLinkResponse(uri.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MembersInfoDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/member/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public UserInfoDto getUserInfo() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/member/info");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<UserInfoDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/member/info returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberSummaryDto getMemberSummary() {
        return this.getMemberSummary(null);
    }

    @Override
    public MemberSummaryDto getMemberSummary(Long custId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse(custId != null ? this.uriWithCustIdParameter("https://members-ng.iracing.com/data/stats/member_summary", custId) : "https://members-ng.iracing.com/data/stats/member_summary");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberSummaryDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/member_summary returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberYearlyDto getMemberStatsYearly(@NonNull Long custId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse(this.uriWithCustIdParameter("https://members-ng.iracing.com/data/stats/member_yearly", custId));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberYearlyDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/member_yearly returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberCareerDto getMemberCareer(@NonNull Long custId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse(this.uriWithCustIdParameter("https://members-ng.iracing.com/data/stats/member_career", custId));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberCareerDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/member_career returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberChartDataDto getMemberChartData(Long custId, CategoryType category, ChartType chartType) {
        try {
            StringBuilder uri = new StringBuilder(this.uriWithCustIdParameter("https://members-ng.iracing.com/data/member/chart_data", custId));
            uri.append("&category_id=").append(category.toCode());
            uri.append("&chart_type=").append(chartType.toCode());
            LinkResponseDto linkResponse = this.getLinkResponse(uri.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberChartDataDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/member/chart_data returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberDivisonDto getMemberDivision(Long seasonId, Long eventType) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/member_division?season_id=" + seasonId.toString() + EVENT_TYPE_URL_PARAM + eventType.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberDivisonDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/member_division returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonDriverStandings(Long seasonId, Long carClassId) {
        return this.getSeasonDriverStandings(seasonId, carClassId, null);
    }

    @Override
    public DriverStandingsDto getSeasonDriverStandings(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_driver_standings?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + (String)(raceWeekNum != null ? RACE_WEEK_NUM_URL_PARAM + raceWeekNum : ""));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_driver_standings returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonSupersessionStandings(Long seasonId, Long carClassId) {
        return this.getSeasonSupersessionStandings(seasonId, carClassId, null);
    }

    @Override
    public DriverStandingsDto getSeasonSupersessionStandings(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_supersession_standings?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + (String)(raceWeekNum != null ? RACE_WEEK_NUM_URL_PARAM + raceWeekNum : ""));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_supersession_standings returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonTeamStandings(Long seasonId, Long carClassId) {
        return this.getSeasonTeamStandings(seasonId, carClassId, null);
    }

    @Override
    public DriverStandingsDto getSeasonTimeTrialStandings(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_tt_standings?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + (String)(raceWeekNum != null ? RACE_WEEK_NUM_URL_PARAM + raceWeekNum : ""));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_tt_standings returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonTimeTrialResults(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_tt_results?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + RACE_WEEK_NUM_URL_PARAM + raceWeekNum.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_tt_results returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonQualifyResults(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_qualify_results?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + RACE_WEEK_NUM_URL_PARAM + raceWeekNum.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_qualify_results returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public DriverStandingsDto getSeasonTimeTrialStandings(Long seasonId, Long carClassId) {
        return this.getSeasonTimeTrialStandings(seasonId, carClassId, null);
    }

    @Override
    public DriverStandingsDto getSeasonTeamStandings(Long seasonId, Long carClassId, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/stats/season_team_standings?season_id=" + seasonId.toString() + CAR_CLASS_ID_URL_PARAM + carClassId.toString() + (String)(raceWeekNum != null ? RACE_WEEK_NUM_URL_PARAM + raceWeekNum : ""));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<DriverStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/season_team_standings returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public MemberRecentRacesDto getMemberRecentRaces(@NonNull Long custId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse(this.uriWithCustIdParameter("https://members-ng.iracing.com/data/stats/member_recent_races", custId));
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<MemberRecentRacesDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/stats/member_recent_races returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public CarInfoDto[] getCarInfo() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/car/get");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<CarInfoDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/car/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public CarClassDto[] getCarClasses() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/carclass/get");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<CarClassDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/carclass/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public ConstantDto[] getDivisions() {
        try {
            return this.getStructuredData("https://members-ng.iracing.com/data/constants/divisions", new TypeReference<ConstantDto[]>(){});
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public ConstantDto[] getCategories() {
        try {
            return this.getStructuredData("https://members-ng.iracing.com/data/constants/categories", new TypeReference<ConstantDto[]>(){});
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public ConstantDto[] getEventTypes() {
        try {
            return this.getStructuredData("https://members-ng.iracing.com/data/constants/event_types", new TypeReference<ConstantDto[]>(){});
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public Map<Long, CarAssetDto> getCarAssets() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/car/assets");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<HashMap<Long, CarAssetDto>>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/car/assets returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public Map<Long, TrackAssetDto> getTrackAssets() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/track/assets");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<HashMap<Long, TrackAssetDto>>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/track/assets returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public Map<Long, SeriesAssetDto> getSeriesAssets() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/series/assets");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<HashMap<Long, SeriesAssetDto>>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/series/assets returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeagueInfoDto getLeagueInfo(long leagueId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/league/get?league_id=" + leagueId);
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LeagueInfoDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public SeasonDto[] getSeasonInfo(Boolean includeSeries) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/series/seasons?include_series=" + includeSeries.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SeasonDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/series/seasons returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public SeriesInfoDto[] getSeriesStats() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/series/stats_series");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SeriesInfoDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/series/stats_series returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public SeriesDto[] getSeries() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/series/get");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SeriesDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/series/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public TrackInfoDto[] getTrackInfos() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/track/get");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<TrackInfoDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/track/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LicenseGroupDto[] getLicenseGroups() {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/lookup/licenses");
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LicenseGroupDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/lookup/licenses returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LookupDto[] getLookup(List<LookupTypes> lookupTypes) {
        try {
            StringBuilder url = new StringBuilder("https://members-ng.iracing.com/data/lookup/get");
            for (int i = 0; i < lookupTypes.size(); ++i) {
                if (i == 0) {
                    url.append('?');
                } else {
                    url.append('&');
                }
                url.append(lookupTypes.get(i).toUrlParameters());
            }
            LinkResponseDto linkResponse = this.getLinkResponse(url.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LookupDto[]>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/lookup/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public SubsessionResultDto getSubsessionResult(Long subsessionId) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/results/get?subsession_id=" + subsessionId.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SubsessionResultDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/results/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LapChartDto getLapChartData(Long subsessionId, Long simsessionNumber) {
        try {
            LinkResponseDto linkResponse = this.getLinkResponse("https://members-ng.iracing.com/data/results/lap_chart_data?subsession_id=" + subsessionId.toString() + SIMSESSION_NUMBER_URL_PARAM + simsessionNumber.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LapChartDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/results/lap_chart_data returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LapDataDto getLapData(Long subsessionId, Long simsessionNumber) {
        return this.getLapData(subsessionId, simsessionNumber, null, false);
    }

    @Override
    public LapDataDto getLapData(Long subsessionId, Long simsessionNumber, Long driverOrTeamId, boolean isTeamId) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/results/lap_data").append(SUBSESSION_ID_URL_PARAM).append(subsessionId).append(SIMSESSION_NUMBER_URL_PARAM).append(simsessionNumber);
            if (driverOrTeamId != null) {
                if (isTeamId) {
                    uri.append("&team_id=").append(driverOrTeamId);
                } else {
                    uri.append("&cust_id=").append(driverOrTeamId);
                }
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LapDataDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/results/lap_data returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public EventLogDto getEventLog(Long subsessionId, Long simsessionNumber) {
        try {
            String uri = "https://members-ng.iracing.com/data/results/event_log?subsession_id=" + subsessionId + SIMSESSION_NUMBER_URL_PARAM + simsessionNumber;
            LinkResponseDto linkResponse = this.getLinkResponse(uri);
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<EventLogDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/results/lap_data returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public List<LapChartEntryDto> getLapEntries(@NonNull ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<LapChartEntryDto[]>(){});
    }

    @Override
    public List<EventLogEntryDto> getEventLogEntries(ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<EventLogEntryDto[]>(){});
    }

    @Override
    public List<DriverStandingDto> getDriverStandingEntries(ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<DriverStandingDto[]>(){});
    }

    @Override
    public List<TeamStandingDto> getTeamStandingEntries(ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<TeamStandingDto[]>(){});
    }

    @Override
    public List<DriverTtStandingDto> getTimeTrialStandingEntries(ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<DriverTtStandingDto[]>(){});
    }

    @Override
    public List<DriverQualifyStandingDto> getQualifyStandingEntries(ChunkInfoDto chunkInfo) {
        return this.getChunkedEntries(chunkInfo, (TypeReference<T[]>)new TypeReference<DriverQualifyStandingDto[]>(){});
    }

    @Override
    public SeasonResultsDto getSeasonResults(Long seasonId) {
        return this.getSeasonResults(seasonId, null, null);
    }

    @Override
    public SeasonResultsDto getSeasonResults(Long seasonId, Long eventType) {
        return this.getSeasonResults(seasonId, eventType, null);
    }

    @Override
    public SeasonResultsDto getSeasonResults(Long seasonId, Long eventType, Long raceWeekNum) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/results/season_results").append(SEASON_ID_URL_PARAM).append(seasonId);
            if (eventType != null) {
                uri.append(EVENT_TYPE_URL_PARAM).append(eventType);
            }
            if (raceWeekNum != null) {
                uri.append(RACE_WEEK_NUM_URL_PARAM).append(raceWeekNum);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SeasonResultsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/results/season_results returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public TeamInfoDto getTeamMembers(Long teamId) {
        try {
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/team/get").append("?team_id=").append(teamId);
            LinkResponseDto linkResponse = this.getLinkResponse(uri.toString());
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<TeamInfoDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/team/get returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public CustLeagueSessionsDto getLeagueSessions(@NonNull Boolean mine) {
        return this.getLeagueSessions(mine, null);
    }

    @Override
    public CustLeagueSessionsDto getLeagueSessions(@NonNull Boolean mine, @Nullable Long packageId) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/league/cust_league_sessions").append("?mine=").append(mine);
            if (packageId != null) {
                uri.append("&package_id=").append(packageId);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<CustLeagueSessionsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/cust_league_sessions returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeagueDirectoryDto searchLeagueDirectory(SearchRequestDto searchRequest) {
        try {
            String uri = "https://members-ng.iracing.com/data/league/directory" + searchRequest.toQueryString();
            LinkResponseDto linkResponse = this.getLinkResponse(uri);
            if (linkResponse != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LeagueDirectoryDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/directory returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeaguePointSystemsDto getLeaguePointSystems(Long leagueId, Long seasonId) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/league/get_points_systems").append(LEAGUE_ID_URL_PARAM).append(leagueId);
            if (seasonId != null) {
                uri.append(SEASON_ID_URL_PARAM2).append(seasonId);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LeaguePointSystemsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/get_points_systems returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeaguePointSystemsDto getLeaguePointSystems(Long leagueId) {
        return this.getLeaguePointSystems(leagueId, null);
    }

    @Override
    public LeagueSeasonsDto getLeagueSeasons(Long leagueId, Boolean retired) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/league/seasons").append(LEAGUE_ID_URL_PARAM).append(leagueId);
            if (retired != null) {
                uri.append("&retired=").append(retired);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LeagueSeasonsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/seasons returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeagueSeasonsDto getLeagueSeasons(Long leagueId) {
        return this.getLeagueSeasons(leagueId, null);
    }

    @Override
    public SeasonStandingsDto getLeagueSeasonStandings(Long leagueId, Long seasonId, Long carClassId, Long carId) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/league/season_standings").append(LEAGUE_ID_URL_PARAM).append(leagueId).append(SEASON_ID_URL_PARAM2).append(seasonId);
            if (carClassId != null) {
                uri.append(CAR_CLASS_ID_URL_PARAM).append(carClassId);
            }
            if (carId != null) {
                uri.append("&car_id=").append(carId);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<SeasonStandingsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/season_standings returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public SeasonStandingsDto getLeagueSeasonStandings(Long leagueId, Long seasonId, Long carClassId) {
        return this.getLeagueSeasonStandings(leagueId, seasonId, carClassId, null);
    }

    @Override
    public SeasonStandingsDto getLeagueSeasonStandings(Long leagueId, Long seasonId) {
        return this.getLeagueSeasonStandings(leagueId, seasonId, null, null);
    }

    @Override
    public LeagueSeasonSessionsDto getLeagueSeasonSessions(Long leagueId, Long seasonId, Boolean resultsOnly) {
        try {
            LinkResponseDto linkResponse;
            StringBuilder uri = new StringBuilder("https://members-ng.iracing.com/data/league/season_sessions").append(LEAGUE_ID_URL_PARAM).append(leagueId).append(SEASON_ID_URL_PARAM2).append(seasonId);
            if (resultsOnly != null) {
                uri.append("&results_only=").append(resultsOnly);
            }
            if ((linkResponse = this.getLinkResponse(uri.toString())) != null) {
                return this.getStructuredData(linkResponse.getLink(), new TypeReference<LeagueSeasonSessionsDto>(){});
            }
            throw new DataApiException("https://members-ng.iracing.com/data/league/season_sessions returned null body");
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    @Override
    public LeagueSeasonSessionsDto getLeagueSeasonSessions(Long leagueId, Long seasonId) {
        return this.getLeagueSeasonSessions(leagueId, seasonId, null);
    }

    public JsonNode getApiDocs() {
        try {
            return this.getStructuredData("https://members-ng.iracing.com/data/doc", new TypeReference<JsonNode>(){});
        }
        catch (IOException e) {
            throw new DataApiException(e);
        }
    }

    private LinkResponseDto getLinkResponse(@NonNull String uri) throws IOException {
        String response = (String)this.restTemplate.getForEntity(URI.create(uri), String.class).getBody();
        if (response != null && response.contains("Unauthorized")) {
            this.authResponse = null;
            throw new AuthorizationException("No longer authorized, call authenticate()");
        }
        if (response == null) {
            throw new DataApiException("Null body from " + uri);
        }
        return (LinkResponseDto)this.mapper.readValue(response, LinkResponseDto.class);
    }

    private <T> T getStructuredData(@NonNull String link, @NonNull TypeReference<T> targetType) throws IOException {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)link);
        ResponseEntity infoResponse = this.restTemplate.getForEntity(uriBuilder.build(true).toUri(), String.class);
        String infoResponseBody = (String)infoResponse.getBody();
        if (this.isLogResponseJson()) {
            this.jsonLogger.info("{}: {}", (Object)targetType.getType().getTypeName(), (Object)infoResponseBody);
        }
        if (infoResponseBody != null) {
            return (T)this.mapper.readValue(infoResponseBody, targetType);
        }
        throw new DataApiException("Null body from AWS, status code " + infoResponse.getStatusCode());
    }

    private <T> List<T> getChunkedEntries(ChunkInfoDto chunkInfo, TypeReference<T[]> targetType) {
        ArrayList resultList = new ArrayList();
        Arrays.stream(chunkInfo.getChunkFileNames()).forEach(chunk -> {
            try {
                Object[] chunkEntries = (Object[])this.getStructuredData(chunkInfo.getBaseDownloadUrl() + chunk, targetType);
                resultList.addAll(List.of(chunkEntries));
            }
            catch (IOException e) {
                throw new DataApiException(e);
            }
        });
        return resultList;
    }

    private String uriWithCustIdParameter(@NonNull String baseUri, @NonNull Long custId) {
        return baseUri + "?cust_id=" + custId;
    }

    public static class StatefulRestTemplateInterceptor
    implements ClientHttpRequestInterceptor {
        private List<String> cookie;

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            if (this.cookie != null) {
                request.getHeaders().addAll("Cookie", this.cookie);
            }
            HttpHeaders requestHeaders = request.getHeaders();
            log.debug("REQUEST-HEADERS");
            requestHeaders.forEach((k, v) -> log.debug("{}={}", k, v));
            log.debug("Request-Uri: {}", (Object)request.getURI());
            ClientHttpResponse response = execution.execute(request, body);
            if (this.cookie == null) {
                this.cookie = response.getHeaders().get((Object)"Set-Cookie");
            }
            log.debug("RESPONSE-HEADERS");
            HttpHeaders responseHeaders = response.getHeaders();
            responseHeaders.forEach((k, v) -> log.debug("{}={}", k, v));
            return response;
        }

        public void flushCookies() {
            this.cookie = null;
        }
    }
}

