/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.model.search;

import de.bausdorf.simracing.irdataapi.model.search.LeagueSortType;
import de.bausdorf.simracing.irdataapi.model.search.SearchParameter;
import de.bausdorf.simracing.irdataapi.model.search.SearchRequestDto;

public class LeagueSearchRequestDto
extends SearchRequestDto {
    private final SearchParameter<Boolean> restrictToMember;
    private final SearchParameter<Boolean> restrictToRecruiting;
    private final SearchParameter<Boolean> restrictToFriends;
    private final SearchParameter<Boolean> restrictToWatched;
    private final SearchParameter<Long> minimumRosterCount;
    private final SearchParameter<Long> maximumRosterCount = new SearchParameter("maximum_roster_count");
    private final SearchParameter<LeagueSortType> sort;

    private LeagueSearchRequestDto() {
        this.minimumRosterCount = new SearchParameter("minimum_roster_count");
        this.restrictToFriends = new SearchParameter("restrict_to_friends");
        this.restrictToMember = new SearchParameter("restrict_to_member");
        this.restrictToRecruiting = new SearchParameter("restrict_to_recruiting");
        this.restrictToWatched = new SearchParameter("restrict_to_watched");
        this.sort = new SearchParameter("sort");
    }

    public static LeagueSearchRequestDto create() {
        return new LeagueSearchRequestDto();
    }

    public LeagueSearchRequestDto withSort(LeagueSortType sortType) {
        this.sort.setParameterValue(sortType);
        return this;
    }

    public LeagueSearchRequestDto withMaximumRosterCount(Long maximumRosterCount) {
        this.maximumRosterCount.setParameterValue(maximumRosterCount);
        return this;
    }

    public LeagueSearchRequestDto withMinimumRosterCount(Long minimumRosterCount) {
        this.minimumRosterCount.setParameterValue(minimumRosterCount);
        return this;
    }

    public LeagueSearchRequestDto withRestrictToFriends(Boolean restrictToFriends) {
        this.restrictToFriends.setParameterValue(restrictToFriends);
        return this;
    }

    public LeagueSearchRequestDto withRestrictToWatched(Boolean restrictToWatched) {
        this.restrictToWatched.setParameterValue(restrictToWatched);
        return this;
    }

    public LeagueSearchRequestDto withRestrictToMember(Boolean restrictToMember) {
        this.restrictToMember.setParameterValue(restrictToMember);
        return this;
    }

    public LeagueSearchRequestDto withRestrictToRecruiting(Boolean restrictToRecruiting) {
        this.restrictToRecruiting.setParameterValue(restrictToRecruiting);
        return this;
    }

    @Override
    protected String toParameterString() {
        return super.toParameterString() + this.sort.toUrlParameter() + this.restrictToWatched.toUrlParameter() + this.restrictToRecruiting.toUrlParameter() + this.restrictToMember.toUrlParameter() + this.restrictToFriends.toUrlParameter() + this.minimumRosterCount.toUrlParameter() + this.maximumRosterCount.toUrlParameter();
    }
}

