/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.model.search;

import de.bausdorf.simracing.irdataapi.model.search.OrderType;
import de.bausdorf.simracing.irdataapi.model.search.SearchParameter;

public abstract class SearchRequestDto {
    private final SearchParameter<Long> lowerBound;
    private final SearchParameter<Long> upperBound = new SearchParameter("upperbound");
    private final SearchParameter<String> search;
    private final SearchParameter<OrderType> order;

    protected SearchRequestDto() {
        this.lowerBound = new SearchParameter("lowerbound");
        this.search = new SearchParameter("search");
        this.order = new SearchParameter("order");
    }

    public SearchRequestDto withLowerBound(Long lowerBound) {
        this.lowerBound.setParameterValue(lowerBound);
        return this;
    }

    public SearchRequestDto withUpperBound(Long upperBound) {
        this.upperBound.setParameterValue(upperBound);
        return this;
    }

    public SearchRequestDto withSearch(String search) {
        this.search.setParameterValue(search);
        return this;
    }

    public SearchRequestDto withOrder(OrderType orderType) {
        this.order.setParameterValue(orderType);
        return this;
    }

    public String toQueryString() {
        return this.toParameterString().replaceFirst("&", "?");
    }

    protected String toParameterString() {
        return this.lowerBound.toUrlParameter() + this.upperBound.toUrlParameter() + this.search.toUrlParameter() + this.order.toUrlParameter();
    }
}

