/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.tools;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.bausdorf.simracing.irdataapi.client.impl.IRacingObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileCache<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonFileCache.class);
    private final IRacingObjectMapper mapper = new IRacingObjectMapper();
    T cachedData;
    private final Path cacheDir;
    private final String cacheName;

    public JsonFileCache(@NonNull String cacheDir, @NonNull String cacheName) {
        if (cacheDir == null) {
            throw new NullPointerException("cacheDir is marked non-null but is null");
        }
        if (cacheName == null) {
            throw new NullPointerException("cacheName is marked non-null but is null");
        }
        this.cacheDir = Paths.get(cacheDir, new String[0]);
        this.cacheName = cacheName;
        try {
            this.cachedData = this.readFromFile(this.getFilePath());
        }
        catch (IOException | ClassNotFoundException e) {
            log.warn("could not fetch data from cache directory {}: {}", (Object)cacheDir, (Object)e.getMessage());
        }
    }

    public boolean cacheExists() {
        return Files.exists(this.cacheDir, new LinkOption[0]);
    }

    public long cacheLastModified() {
        if (this.cacheExists()) {
            File cacheFile = new File(this.getFilePath());
            return cacheFile.lastModified();
        }
        return 0L;
    }

    public void setCachedData(T data) {
        this.cachedData = data;
        try {
            WriteCacheWrapper writeCacheWrapper = new WriteCacheWrapper();
            writeCacheWrapper.setData(data);
            if (data instanceof Collection) {
                writeCacheWrapper.setCollectionTypeName(data.getClass().getName());
                Optional firstElement = ((Collection)data).stream().findFirst();
                firstElement.ifPresent(o -> writeCacheWrapper.setElementTypeName(o.getClass().getName()));
            } else {
                writeCacheWrapper.setElementTypeName(data.getClass().getName());
            }
            this.mapper.writeValue(new File(this.getFilePath()), writeCacheWrapper);
        }
        catch (IOException e) {
            log.error("Unable to write cache file {}: {}", (Object)this.getFilePath(), (Object)e.getMessage());
        }
    }

    private T readFromFile(String fileName) throws IOException, ClassNotFoundException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            ReadCacheWrapper cacheWrapper = (ReadCacheWrapper)this.mapper.readValue(fis, ReadCacheWrapper.class);
            Class<?> elementClass = Class.forName(cacheWrapper.getElementTypeName());
            if (cacheWrapper.getCollectionTypeName() == null) {
                Object object = this.mapper.convertValue(cacheWrapper.getData(), elementClass);
                return (T)object;
            }
            Class<?> collectionClass = Class.forName(cacheWrapper.getCollectionTypeName());
            CollectionType targetType = this.mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
            Object object = this.mapper.convertValue(cacheWrapper.getData(), (JavaType)targetType);
            return (T)object;
        }
    }

    private String getFilePath() {
        return this.cacheDir.toFile().getAbsolutePath() + File.separator + this.cacheName + ".json";
    }

    public T getCachedData() {
        return this.cachedData;
    }

    static class ReadCacheWrapper<T> {
        private String elementTypeName;
        private String collectionTypeName;
        private T data;

        public String getElementTypeName() {
            return this.elementTypeName;
        }

        public String getCollectionTypeName() {
            return this.collectionTypeName;
        }

        public T getData() {
            return this.data;
        }

        public void setElementTypeName(String elementTypeName) {
            this.elementTypeName = elementTypeName;
        }

        public void setCollectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadCacheWrapper)) {
                return false;
            }
            ReadCacheWrapper other = (ReadCacheWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$elementTypeName = this.getElementTypeName();
            String other$elementTypeName = other.getElementTypeName();
            if (this$elementTypeName == null ? other$elementTypeName != null : !this$elementTypeName.equals(other$elementTypeName)) {
                return false;
            }
            String this$collectionTypeName = this.getCollectionTypeName();
            String other$collectionTypeName = other.getCollectionTypeName();
            if (this$collectionTypeName == null ? other$collectionTypeName != null : !this$collectionTypeName.equals(other$collectionTypeName)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadCacheWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $elementTypeName = this.getElementTypeName();
            result = result * 59 + ($elementTypeName == null ? 43 : $elementTypeName.hashCode());
            String $collectionTypeName = this.getCollectionTypeName();
            result = result * 59 + ($collectionTypeName == null ? 43 : $collectionTypeName.hashCode());
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "JsonFileCache.ReadCacheWrapper(elementTypeName=" + this.getElementTypeName() + ", collectionTypeName=" + this.getCollectionTypeName() + ", data=" + this.getData() + ")";
        }
    }

    static class WriteCacheWrapper<T> {
        private String elementTypeName;
        private String collectionTypeName;
        private T data;

        public String getElementTypeName() {
            return this.elementTypeName;
        }

        public String getCollectionTypeName() {
            return this.collectionTypeName;
        }

        public T getData() {
            return this.data;
        }

        public void setElementTypeName(String elementTypeName) {
            this.elementTypeName = elementTypeName;
        }

        public void setCollectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteCacheWrapper)) {
                return false;
            }
            WriteCacheWrapper other = (WriteCacheWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$elementTypeName = this.getElementTypeName();
            String other$elementTypeName = other.getElementTypeName();
            if (this$elementTypeName == null ? other$elementTypeName != null : !this$elementTypeName.equals(other$elementTypeName)) {
                return false;
            }
            String this$collectionTypeName = this.getCollectionTypeName();
            String other$collectionTypeName = other.getCollectionTypeName();
            if (this$collectionTypeName == null ? other$collectionTypeName != null : !this$collectionTypeName.equals(other$collectionTypeName)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WriteCacheWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $elementTypeName = this.getElementTypeName();
            result = result * 59 + ($elementTypeName == null ? 43 : $elementTypeName.hashCode());
            String $collectionTypeName = this.getCollectionTypeName();
            result = result * 59 + ($collectionTypeName == null ? 43 : $collectionTypeName.hashCode());
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "JsonFileCache.WriteCacheWrapper(elementTypeName=" + this.getElementTypeName() + ", collectionTypeName=" + this.getCollectionTypeName() + ", data=" + this.getData() + ")";
        }
    }
}

