/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import de.bausdorf.simracing.irdataapi.client.AuthorizationException;
import de.bausdorf.simracing.irdataapi.client.IrDataClient;
import de.bausdorf.simracing.irdataapi.client.impl.IRacingObjectMapper;
import de.bausdorf.simracing.irdataapi.model.CarAssetDto;
import de.bausdorf.simracing.irdataapi.model.CarClassDto;
import de.bausdorf.simracing.irdataapi.model.CarInfoDto;
import de.bausdorf.simracing.irdataapi.model.ConstantDto;
import de.bausdorf.simracing.irdataapi.model.LicenseGroupDto;
import de.bausdorf.simracing.irdataapi.model.TrackAssetDto;
import de.bausdorf.simracing.irdataapi.model.TrackInfoDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StockDataCache {
    private static final Logger log = LoggerFactory.getLogger(StockDataCache.class);
    public static final String TRACKS_JSON = "tracks.json";
    public static final String TRACK_ASSETS_JSON = "trackAssets.json";
    public static final String CARS_JSON = "cars.json";
    public static final String CAR_CLASSES_JSON = "carClasses.json";
    public static final String CAR_ASSETS_JSON = "carAssets.json";
    public static final String DIVISIONS_JSON = "divisions.json";
    public static final String LICENSE_GROUPS_JSON = "licenseGroups.json";
    private TrackInfoDto[] tracks;
    private Map<Long, TrackAssetDto> trackAssets;
    private CarInfoDto[] cars;
    private CarClassDto[] carClasses;
    private Map<Long, CarAssetDto> carAssets;
    private ConstantDto[] divisions;
    private LicenseGroupDto[] licenseGroups;
    private Path cacheDir;
    private final IRacingObjectMapper mapper = new IRacingObjectMapper();

    public StockDataCache(@NonNull String cacheDir) {
        if (cacheDir == null) {
            throw new NullPointerException("cacheDir is marked non-null but is null");
        }
        this.cacheDir = Paths.get(cacheDir, new String[0]);
        try {
            this.fetchFromCache();
        }
        catch (IOException e) {
            log.warn("could not fetch data from cache directory {}: {}", (Object)cacheDir, (Object)e.getMessage());
        }
    }

    public boolean isInitialized() {
        return this.tracks != null && this.trackAssets != null && this.cars != null && this.carClasses != null && this.carAssets != null && this.divisions != null && this.licenseGroups != null;
    }

    public boolean cacheExists() {
        return Files.exists(this.cacheDir, new LinkOption[0]);
    }

    public Long cacheLastModified() {
        if (this.cacheExists()) {
            File cacheFile = new File(this.cacheDir.toFile().getAbsolutePath() + File.separator + TRACKS_JSON);
            return cacheFile.lastModified();
        }
        return 0L;
    }

    public void fetchFromService(IrDataClient dataClient) {
        if (!dataClient.isAuthenticated()) {
            throw new AuthorizationException("StockDataCache cannot be fetched from unauthorized client");
        }
        this.tracks = dataClient.getTrackInfos();
        this.trackAssets = dataClient.getTrackAssets();
        this.cars = dataClient.getCarInfo();
        this.carClasses = dataClient.getCarClasses();
        this.carAssets = dataClient.getCarAssets();
        this.divisions = dataClient.getDivisions();
        this.licenseGroups = dataClient.getLicenseGroups();
        try {
            if (!this.cacheExists()) {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            }
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + TRACKS_JSON, this.tracks);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + TRACK_ASSETS_JSON, this.trackAssets);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CARS_JSON, this.cars);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CAR_CLASSES_JSON, this.carClasses);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CAR_ASSETS_JSON, this.carAssets);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + DIVISIONS_JSON, this.divisions);
            this.writeToFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + LICENSE_GROUPS_JSON, this.licenseGroups);
        }
        catch (IOException e) {
            log.error("Unable to write StockDataCache directory {}: {}", (Object)this.cacheDir, (Object)e.getMessage());
        }
    }

    public void fetchFromCache() throws IOException {
        this.tracks = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + TRACKS_JSON, new TypeReference<TrackInfoDto[]>(){});
        this.trackAssets = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + TRACK_ASSETS_JSON, new TypeReference<Map<Long, TrackAssetDto>>(){});
        this.cars = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CARS_JSON, new TypeReference<CarInfoDto[]>(){});
        this.carClasses = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CAR_CLASSES_JSON, new TypeReference<CarClassDto[]>(){});
        this.carAssets = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + CAR_ASSETS_JSON, new TypeReference<Map<Long, CarAssetDto>>(){});
        this.divisions = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + DIVISIONS_JSON, new TypeReference<ConstantDto[]>(){});
        this.licenseGroups = this.readFromFile(this.cacheDir.toFile().getAbsolutePath() + File.separator + LICENSE_GROUPS_JSON, new TypeReference<LicenseGroupDto[]>(){});
    }

    private <T> T readFromFile(String fileName, TypeReference<T> targetType) throws IOException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            Object object = this.mapper.readValue(fis, targetType);
            return (T)object;
        }
    }

    private <T> void writeToFile(String fileName, T data) throws IOException {
        this.mapper.writeValue(new File(fileName), data);
    }

    public TrackInfoDto[] getTracks() {
        return this.tracks;
    }

    public Map<Long, TrackAssetDto> getTrackAssets() {
        return this.trackAssets;
    }

    public CarInfoDto[] getCars() {
        return this.cars;
    }

    public CarClassDto[] getCarClasses() {
        return this.carClasses;
    }

    public Map<Long, CarAssetDto> getCarAssets() {
        return this.carAssets;
    }

    public ConstantDto[] getDivisions() {
        return this.divisions;
    }

    public LicenseGroupDto[] getLicenseGroups() {
        return this.licenseGroups;
    }

    public Path getCacheDir() {
        return this.cacheDir;
    }

    public IRacingObjectMapper getMapper() {
        return this.mapper;
    }

    public void setCacheDir(Path cacheDir) {
        this.cacheDir = cacheDir;
    }
}

