/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.tools;

import de.bausdorf.simracing.irdataapi.model.CarClassDto;
import de.bausdorf.simracing.irdataapi.model.CarClassKey;
import de.bausdorf.simracing.irdataapi.model.CarInfoDto;
import de.bausdorf.simracing.irdataapi.model.TrackInfoDto;
import de.bausdorf.simracing.irdataapi.tools.CarCategoryType;
import de.bausdorf.simracing.irdataapi.tools.MainCarType;
import de.bausdorf.simracing.irdataapi.tools.TrackType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockDataTools {
    private static final Logger log = LoggerFactory.getLogger(StockDataTools.class);
    public static final String LEGACY = "[Legacy]";

    public static Map<String, List<TrackInfoDto>> trackConfigurationMap(TrackInfoDto[] trackInfoDtos) {
        TreeMap<String, List<TrackInfoDto>> trackConfigMap = new TreeMap<String, List<TrackInfoDto>>();
        Arrays.stream(trackInfoDtos).filter(track -> Arrays.stream(track.getTrackTypes()).anyMatch(type -> "road".equalsIgnoreCase(type.getTrackType()))).sorted(Comparator.comparing(TrackInfoDto::getTrackName)).forEach(trackConfig -> {
            trackConfigMap.computeIfAbsent(trackConfig.getTrackName(), k -> trackConfigMap.put((String)k, new ArrayList()));
            ((List)trackConfigMap.get(trackConfig.getTrackName())).add(trackConfig);
        });
        return trackConfigMap;
    }

    public static Map<CarClassKey, List<CarInfoDto>> carClassMap(CarClassDto[] carClasses, CarInfoDto[] cars) {
        HashMap<CarClassKey, List<CarInfoDto>> carClassMap = new HashMap<CarClassKey, List<CarInfoDto>>();
        Arrays.stream(carClasses).forEach(carClass -> {
            CarClassKey classKey = new CarClassKey((CarClassDto)carClass);
            ArrayList carsInClass = new ArrayList();
            Arrays.stream(carClass.getCarsInClass()).forEach(carInClass -> carsInClass.addAll(Arrays.stream(cars).filter(car -> car.getCarId().equals(carInClass.getCarId())).collect(Collectors.toList())));
            carClassMap.put(classKey, carsInClass);
        });
        return carClassMap;
    }

    public static List<CarInfoDto> carsInClasses(List<Long> carClassIds, CarClassDto[] carClasses, CarInfoDto[] cars) {
        ArrayList<CarInfoDto> carsInClasses = new ArrayList<CarInfoDto>();
        Arrays.stream(carClasses).filter(carClass -> carClassIds.contains(carClass.getCarClassId())).forEach(carClass -> Arrays.stream(cars).filter(car -> Arrays.stream(carClass.getCarsInClass()).anyMatch(carInClass -> carInClass.getCarId().equals(car.getCarId()))).forEach(carsInClasses::add));
        return carsInClasses;
    }

    public static NavigableSet<String> fetchAvailableCarTypes(CarInfoDto[] cars, MainCarType mainType) {
        TreeSet<String> carTypes = new TreeSet<String>();
        Arrays.stream(cars).filter(car -> Arrays.stream(car.getCarTypes()).anyMatch(type -> type.getCarType().equalsIgnoreCase(mainType.toString()))).forEach(car -> Arrays.stream(car.getCarTypes()).forEach(type -> carTypes.add(type.getCarType())));
        return carTypes;
    }

    public static List<CarInfoDto> carsByType(CarInfoDto[] cars, String carType, boolean includeLegacy) {
        return Arrays.stream(cars).filter(car -> Arrays.stream(car.getCarTypes()).anyMatch(type -> type.getCarType().equalsIgnoreCase(carType))).filter(car -> includeLegacy || !car.getCarName().contains(LEGACY)).collect(Collectors.toList());
    }

    public static List<CarInfoDto> carsByCategory(CarInfoDto[] cars, CarCategoryType carType, boolean includeLegacy) {
        return Arrays.stream(cars).filter(car -> Arrays.stream(car.getCarTypes()).anyMatch(type -> type.getCarType().equalsIgnoreCase(carType.toString()))).filter(car -> includeLegacy || !car.getCarName().contains(LEGACY)).collect(Collectors.toList());
    }

    public static List<CarInfoDto> carsByType(CarInfoDto[] cars, List<String> carTypes, boolean includeLegacy) {
        return Arrays.stream(cars).filter(car -> Arrays.stream(car.getCarTypes()).anyMatch(type -> carTypes.contains(type.getCarType()))).filter(car -> includeLegacy || !car.getCarName().contains(LEGACY)).collect(Collectors.toList());
    }

    public static List<TrackInfoDto> tracksByType(TrackInfoDto[] tracks, TrackType trackType, boolean includeLegacy) {
        return Arrays.stream(tracks).filter(track -> Arrays.stream(track.getTrackTypes()).anyMatch(type -> type.getTrackType().equalsIgnoreCase(trackType.toString()))).filter(track -> includeLegacy || !track.getTrackName().contains(LEGACY)).collect(Collectors.toList());
    }

    private StockDataTools() {
    }
}

