/*
 * Decompiled with CFR 0.152.
 */
package de.bausdorf.simracing.irdataapi.model.search;

import de.bausdorf.simracing.irdataapi.model.search.LeagueSortType;
import de.bausdorf.simracing.irdataapi.model.search.OrderType;
import de.bausdorf.simracing.irdataapi.model.search.SearchParameter;
import de.bausdorf.simracing.irdataapi.model.search.SearchRequest;

public class LeagueSearchRequest
extends SearchRequest {
    private final SearchParameter<Boolean> restrictToMember;
    private final SearchParameter<Boolean> restrictToRecruiting;
    private final SearchParameter<Boolean> restrictToFriends;
    private final SearchParameter<Boolean> restrictToWatched;
    private final SearchParameter<Long> minimumRosterCount;
    private final SearchParameter<Long> maximumRosterCount = new SearchParameter("maximum_roster_count");
    private final SearchParameter<LeagueSortType> sort;
    private final SearchParameter<Long> lowerBound;
    private final SearchParameter<Long> upperBound;
    private final SearchParameter<String> search;
    private final SearchParameter<OrderType> order;

    private LeagueSearchRequest() {
        this.minimumRosterCount = new SearchParameter("minimum_roster_count");
        this.restrictToFriends = new SearchParameter("restrict_to_friends");
        this.restrictToMember = new SearchParameter("restrict_to_member");
        this.restrictToRecruiting = new SearchParameter("restrict_to_recruiting");
        this.restrictToWatched = new SearchParameter("restrict_to_watched");
        this.sort = new SearchParameter("sort");
        this.upperBound = new SearchParameter("upperbound");
        this.lowerBound = new SearchParameter("lowerbound");
        this.search = new SearchParameter("search");
        this.order = new SearchParameter("order");
    }

    public static LeagueSearchRequest create() {
        return new LeagueSearchRequest();
    }

    public LeagueSearchRequest withSort(LeagueSortType sortType) {
        this.sort.setParameterValue(sortType);
        return this;
    }

    public LeagueSearchRequest withMaximumRosterCount(Long maximumRosterCount) {
        this.maximumRosterCount.setParameterValue(maximumRosterCount);
        return this;
    }

    public LeagueSearchRequest withMinimumRosterCount(Long minimumRosterCount) {
        this.minimumRosterCount.setParameterValue(minimumRosterCount);
        return this;
    }

    public LeagueSearchRequest withRestrictToFriends(Boolean restrictToFriends) {
        this.restrictToFriends.setParameterValue(restrictToFriends);
        return this;
    }

    public LeagueSearchRequest withRestrictToWatched(Boolean restrictToWatched) {
        this.restrictToWatched.setParameterValue(restrictToWatched);
        return this;
    }

    public LeagueSearchRequest withRestrictToMember(Boolean restrictToMember) {
        this.restrictToMember.setParameterValue(restrictToMember);
        return this;
    }

    public LeagueSearchRequest withRestrictToRecruiting(Boolean restrictToRecruiting) {
        this.restrictToRecruiting.setParameterValue(restrictToRecruiting);
        return this;
    }

    public LeagueSearchRequest withLowerBound(Long lowerBound) {
        this.lowerBound.setParameterValue(lowerBound);
        return this;
    }

    public LeagueSearchRequest withUpperBound(Long upperBound) {
        this.upperBound.setParameterValue(upperBound);
        return this;
    }

    public LeagueSearchRequest withSearch(String search) {
        this.search.setParameterValue(search);
        return this;
    }

    public LeagueSearchRequest withOrder(OrderType orderType) {
        this.order.setParameterValue(orderType);
        return this;
    }

    @Override
    protected String toParameterString() {
        return this.lowerBound.toUrlParameter() + this.upperBound.toUrlParameter() + this.search.toUrlParameter() + this.order.toUrlParameter() + this.sort.toUrlParameter() + this.restrictToWatched.toUrlParameter() + this.restrictToRecruiting.toUrlParameter() + this.restrictToMember.toUrlParameter() + this.restrictToFriends.toUrlParameter() + this.minimumRosterCount.toUrlParameter() + this.maximumRosterCount.toUrlParameter();
    }
}

