/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.validation;

import de.bechte.junit.runners.validation.TestClassValidator;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.TestClass;

public abstract class BooleanValidator
implements TestClassValidator {
    protected final TestClassValidator[] validators;

    public static BooleanValidator AND(TestClassValidator ... validators) {
        return new AndValidator(validators);
    }

    public static BooleanValidator OR(TestClassValidator ... validators) {
        return new OrValidator(validators);
    }

    private BooleanValidator(TestClassValidator[] validators) {
        this.validators = validators == null ? new TestClassValidator[]{} : validators;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrValidator
    extends BooleanValidator {
        public OrValidator(TestClassValidator[] validators) {
            super(validators);
        }

        @Override
        public void validate(TestClass testClass, List<Throwable> errors) {
            ArrayList<Throwable> tempErrors = new ArrayList<Throwable>();
            ArrayList<Throwable> currentErrors = new ArrayList<Throwable>();
            for (TestClassValidator validator : this.validators) {
                currentErrors.clear();
                validator.validate(testClass, currentErrors);
                if (currentErrors.isEmpty()) {
                    tempErrors.clear();
                    break;
                }
                tempErrors.addAll(currentErrors);
            }
            errors.addAll(tempErrors);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndValidator
    extends BooleanValidator {
        public AndValidator(TestClassValidator[] validators) {
            super(validators);
        }

        @Override
        public void validate(TestClass testClass, List<Throwable> errors) {
            for (TestClassValidator validator : this.validators) {
                validator.validate(testClass, errors);
            }
        }
    }
}

