/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.description;

import de.bechte.junit.runners.context.description.Describer;
import de.bechte.junit.runners.context.processing.ChildResolver;
import de.bechte.junit.runners.model.TestClassPool;
import org.junit.runner.Description;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteDescriber
implements Describer<Class<?>> {
    private final ChildResolver<Class<?>> childResolver;

    public SuiteDescriber(ChildResolver<Class<?>> childResolver) {
        this.childResolver = childResolver;
    }

    @Override
    public Description describe(Class<?> suiteClass) {
        if (suiteClass == null) {
            throw new IllegalArgumentException("Class must not be null!");
        }
        Description description = Description.createSuiteDescription(suiteClass);
        TestClass testClass = TestClassPool.forClass(suiteClass);
        this.addChildren(description, testClass);
        return description;
    }

    protected void addChildren(Description description, TestClass testClass) {
        for (Class<?> child : this.childResolver.getChildren(testClass)) {
            description.addChild(this.describe(child));
        }
    }
}

