/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.processing;

import de.bechte.junit.runners.context.processing.ChildResolver;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextResolver
implements ChildResolver<Class<?>> {
    @Override
    public List<Class<?>> getChildren(TestClass testClass) {
        if (testClass == null) {
            return Collections.emptyList();
        }
        Class<?>[] memberClasses = testClass.getJavaClass().getClasses();
        ArrayList contexts = new ArrayList(memberClasses.length);
        for (Class<?> memberClass : memberClasses) {
            if (!this.isAllowed(memberClass)) continue;
            contexts.add(memberClass);
        }
        return contexts;
    }

    protected boolean isAllowed(Class<?> candidate) {
        return this.isNotAbstract(candidate) && this.isNotStatic(candidate) && this.isPublic(candidate) && this.isNotIgnored(candidate);
    }

    private boolean isNotAbstract(Class<?> candidate) {
        return !Modifier.isAbstract(candidate.getModifiers());
    }

    private boolean isNotStatic(Class<?> candidate) {
        return !Modifier.isStatic(candidate.getModifiers());
    }

    private boolean isPublic(Class<?> candidate) {
        return Modifier.isPublic(candidate.getModifiers());
    }

    private boolean isNotIgnored(Class<?> candidate) {
        return candidate.getAnnotation(Ignore.class) == null;
    }
}

