/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements;

import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class StatementExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Statement statement, RunNotifier notifier, Description description) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        try {
            this.beforeExecution(eachNotifier);
            statement.evaluate();
        }
        catch (InitializationError e) {
            this.whenInitializationErrorIsRaised(eachNotifier, e);
        }
        catch (AssumptionViolatedException e) {
            this.whenAssumptionViolatedExceptionIsRaised(eachNotifier, e);
        }
        catch (Throwable e) {
            this.whenThrowableIsRaised(eachNotifier, e);
        }
        finally {
            this.afterExecution(eachNotifier);
        }
    }

    protected void beforeExecution(EachTestNotifier notifier) {
    }

    protected void whenInitializationErrorIsRaised(EachTestNotifier notifier, InitializationError e) {
        notifier.addFailure((Throwable)new MultipleFailureException(e.getCauses()));
    }

    protected void whenAssumptionViolatedExceptionIsRaised(EachTestNotifier notifier, AssumptionViolatedException e) {
        notifier.addFailedAssumption(e);
    }

    protected void whenThrowableIsRaised(EachTestNotifier notifier, Throwable e) {
        notifier.addFailure(e);
    }

    protected void afterExecution(EachTestNotifier notifier) {
    }
}

