/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.jsunit.maven2;

import de.berlios.jsunit.JsUnitException;
import de.berlios.jsunit.JsUnitRhinoRunner;
import de.berlios.jsunit.JsUnitRuntimeException;
import de.berlios.jsunit.maven2.JsUnitSuite;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class JsUnitMojo
extends AbstractMojo {
    private static final String RUN_ALLTESTS = "ALLTESTS";
    private static final String RUN_TESTSUITES = "TESTSUITES";
    private static final String RUN_TESTCASES = "TESTCASES";
    private static final List RUN_TYPES = new ArrayList<String>(Arrays.asList("ALLTESTS", "TESTSUITES", "TESTCASES"));
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*Test.js", "**/AllTests.js"};
    private MavenProject project;
    private boolean skip;
    private boolean skipExec;
    private boolean testFailureIgnore;
    private File reportsDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private boolean printSummary;
    private String[] sources;
    private JsUnitSuite[] testSuites;
    private Log logger;

    public void execute() throws MojoFailureException, MojoExecutionException {
        this.logger = this.getLog();
        if (!this.sourceDirectory.isDirectory()) {
            this.logger.info((CharSequence)"No JavaScript source directory, skipping JsUnit tests");
            return;
        }
        if (!this.testSourceDirectory.isDirectory()) {
            this.logger.info((CharSequence)"No JavaScript test source directory, skipping JsUnit tests");
            return;
        }
        if (this.skip) {
            this.logger.info((CharSequence)"Skipping JsUnit tests");
        }
        if (this.testSuites.length == 0 && !this.skipExec) {
            throw new MojoFailureException("No test suites defined");
        }
        if (!(this.skipExec || this.reportsDirectory.isDirectory() || this.reportsDirectory.mkdirs())) {
            throw new MojoExecutionException("Cannot create report directry " + this.reportsDirectory.toString());
        }
        for (int i = 0; i < this.testSuites.length; ++i) {
            JsUnitSuite suite = this.testSuites[i];
            if (RUN_TYPES.contains(suite.getType())) continue;
            throw new MojoFailureException("Unknown run type " + suite.getType());
        }
        int errors = 0;
        int failures = 0;
        for (int i = 0; i < this.testSuites.length || this.skipExec && this.testSuites.length == 0; ++i) {
            OutputStreamWriter writer;
            File file;
            JsUnitRhinoRunner runner = null;
            try {
                runner = new JsUnitRhinoRunner();
            }
            catch (JsUnitRuntimeException e) {
                throw new MojoExecutionException("Cannot evaluate JavaScript code of JsUnit", (Exception)((Object)e));
            }
            if (this.sources != null) {
                for (int j = 0; j < this.sources.length; ++j) {
                    File file2 = new File(this.sourceDirectory, this.sources[j]);
                    try {
                        runner.load((Reader)new FileReader(file2), file2.getName());
                        this.logger.debug((CharSequence)("Loaded " + file2.getName()));
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new MojoExecutionException("Cannot find " + file2.getName(), (Exception)e);
                    }
                    catch (JsUnitException e) {
                        throw new MojoExecutionException("Cannot evaluate JavaScript code of " + file2.getName(), (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Cannot read complete " + file2.getName(), (Exception)e);
                    }
                }
            } else {
                this.logger.info((CharSequence)"No JavaScript sources defined");
            }
            if (this.skipExec && this.testSuites.length == 0) break;
            JsUnitSuite suite = this.testSuites[i];
            String[] includes = suite.getIncludes().isEmpty() ? DEFAULT_INCLUDES : suite.getIncludes().toArray(new String[suite.getIncludes().size()]);
            suite.getIncludes();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.testSourceDirectory);
            scanner.setIncludes(includes);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                file = new File(scanner.getBasedir(), files[j]);
                try {
                    runner.load((Reader)new FileReader(file), files[i]);
                    this.logger.debug((CharSequence)("Loaded " + file.getPath()));
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("Cannot find " + file.getPath(), (Exception)e);
                }
                catch (JsUnitException e) {
                    throw new MojoExecutionException("Cannot evaluate JavaScript code of " + file.getPath(), (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot read complete " + file.getPath(), (Exception)e);
                }
            }
            if (this.skipExec) continue;
            String name = suite.getName();
            file = new File(this.reportsDirectory, "TEST-" + name + ".xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                writer = new OutputStreamWriter((OutputStream)new TeeOutputStream((OutputStream)new FileOutputStream(file), (OutputStream)baos));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create file " + file.getName(), (Exception)e);
            }
            try {
                switch (RUN_TYPES.indexOf(suite.getType())) {
                    case 0: {
                        runner.runAllTests((Writer)writer);
                        break;
                    }
                    case 1: {
                        runner.runTestSuites((Writer)writer, name);
                        break;
                    }
                    case 2: {
                        runner.runTestCases((Writer)writer, name);
                    }
                }
                this.logger.debug((CharSequence)("Created test report " + file.getName()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write to file " + file.getName(), (Exception)e);
            }
            finally {
                IOUtil.close((Writer)writer);
            }
            try {
                String report = baos.toString();
                Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new StringReader(report));
                errors += Integer.parseInt(dom.getAttribute("errors"));
                failures += Integer.parseInt(dom.getAttribute("failures"));
                continue;
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Cannot parse report of test suite " + name, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot read report of test suite " + name, (Exception)e);
            }
        }
        if (errors + failures > 0) {
            String msg = "There have been " + errors + " errors and " + failures + " failures testing JavaScript";
            if (this.testFailureIgnore) {
                this.logger.error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }
}

