/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.gyration;

import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import java.util.List;
import java.util.stream.Collectors;

public class Gyration {
    private final List<Atom> atoms;
    private double radius;
    private Vector3D centroid;

    private Gyration(List<Atom> atoms) {
        this.atoms = atoms;
        this.calculateRadius();
    }

    public static Gyration of(AtomContainer atomContainer) {
        return new Gyration(atomContainer.getAllAtoms());
    }

    public List<Atom> getAtoms() {
        return this.atoms;
    }

    public Vector3D getCentroid() {
        return this.centroid;
    }

    public double getRadius() {
        return this.radius;
    }

    private void calculateRadius() {
        List positions = this.atoms.stream().map(Atom::getPosition).collect(Collectors.toList());
        this.centroid = Vectors3D.getCentroid(positions);
        double sumOfSquaredDistances = 0.0;
        double sumOfMolecularMass = 0.0;
        for (Atom atom : this.atoms) {
            sumOfSquaredDistances += atom.getElement().getAtomicMass().getValue().doubleValue() * VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistance((Vector)atom.getPosition(), (Vector)this.centroid);
            sumOfMolecularMass += atom.getElement().getAtomicMass().getValue().doubleValue();
        }
        this.radius = Math.sqrt(sumOfSquaredDistances / sumOfMolecularMass);
    }
}

