/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.molecules;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.algorithms.graphs.isomorphism.RISubgraphFinder;
import de.bioforscher.singa.mathematics.graphs.model.AbstractNode;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MoleculeIsomorphism {
    private final RISubgraphFinder<MoleculeAtom, MoleculeBond, Vector2D, Integer, MoleculeGraph> finder;
    private List<MoleculeGraph> fullMatches;

    public MoleculeIsomorphism(RISubgraphFinder<MoleculeAtom, MoleculeBond, Vector2D, Integer, MoleculeGraph> finder) {
        this.finder = finder;
        this.fullMatches = new ArrayList<MoleculeGraph>();
        this.determineMatches();
    }

    private void determineMatches() {
        for (List pairs : this.finder.getFullMatchPairs()) {
            MoleculeGraph copy = (MoleculeGraph)((MoleculeGraph)this.finder.getTargetGraph()).getCopy();
            ArrayList<Object> identifiersToKeep = new ArrayList<Object>();
            for (Pair pair : pairs) {
                MoleculeAtom matchingAtom = (MoleculeAtom)((Object)pair.getSecond());
                identifiersToKeep.add(matchingAtom.getIdentifier());
            }
            List<Integer> identifiersToRemove = copy.getNodes().stream().map(AbstractNode::getIdentifier).collect(Collectors.toList());
            identifiersToRemove.removeAll(identifiersToKeep);
            identifiersToRemove.forEach(arg_0 -> ((MoleculeGraph)copy).removeNode(arg_0));
            this.fullMatches.add(copy);
        }
    }

    public List<MoleculeGraph> getFullMatches() {
        return this.fullMatches;
    }

    public List<Pair<MoleculeAtom>> getAtomPairs(MoleculeGraph fullMatch) {
        if (!this.fullMatches.contains((Object)fullMatch)) {
            throw new IllegalArgumentException("Pairs can only be retrieved for graphs that are full matches of the this isomorphism.");
        }
        return (List)this.finder.getFullMatchPairs().get(this.fullMatches.indexOf((Object)fullMatch));
    }

    public void reduceMatches() {
        Function<MoleculeGraph, Set> keyFunction = a -> new HashSet(a.getNodes());
        HashMap uniqueMatches = this.fullMatches.stream().collect(Collectors.toMap(keyFunction, p -> p, (p, q) -> p, HashMap::new));
        this.fullMatches = new ArrayList(uniqueMatches.values());
    }
}

