/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.molecules;

import de.bioforscher.singa.mathematics.algorithms.graphs.isomorphism.RISubgraphFinder;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.structure.algorithms.molecules.MoleculeIsomorphism;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoleculeIsomorphismFinder {
    private static final Logger logger = LoggerFactory.getLogger(MoleculeIsomorphismFinder.class);
    private static final BiFunction<MoleculeAtom, MoleculeAtom, Boolean> DEFAULT_ATOM_CONDITION = AtomConditions.isSameElement();
    private static final BiFunction<MoleculeBond, MoleculeBond, Boolean> DEFAULT_BOND_CONDITION = BondConditions.isSameType();
    private final BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition;
    private final BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition;
    private MoleculeGraph pattern;
    private MoleculeGraph target;

    private MoleculeIsomorphismFinder(MoleculeGraph pattern, MoleculeGraph target, BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition, BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition) {
        logger.info("molecule isomorphism finder initialized with pattern {} against target {}", (Object)pattern, (Object)target);
        this.pattern = pattern;
        this.target = target;
        this.atomCondition = atomCondition;
        this.bondCondition = bondCondition;
    }

    public static MoleculeIsomorphism of(MoleculeGraph pattern, MoleculeGraph target) {
        return new MoleculeIsomorphismFinder(pattern, target, DEFAULT_ATOM_CONDITION, DEFAULT_BOND_CONDITION).findIsomorphism();
    }

    public static MoleculeIsomorphism of(MoleculeGraph pattern, MoleculeGraph target, BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition, BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition) {
        return new MoleculeIsomorphismFinder(pattern, target, atomCondition, bondCondition).findIsomorphism();
    }

    private MoleculeIsomorphism findIsomorphism() {
        RISubgraphFinder finder = new RISubgraphFinder((Graph)this.pattern, (Graph)this.target, this.atomCondition, this.bondCondition);
        return new MoleculeIsomorphism((RISubgraphFinder<MoleculeAtom, MoleculeBond, Vector2D, Integer, MoleculeGraph>)finder);
    }

    public static final class BondConditions {
        public static BiFunction<MoleculeBond, MoleculeBond, Boolean> isArbitrary() {
            return (patternBond, targetBond) -> true;
        }

        public static BiFunction<MoleculeBond, MoleculeBond, Boolean> isSameType() {
            return (patternBond, targetBond) -> patternBond.getType() == targetBond.getType();
        }
    }

    public static final class AtomConditions {
        public static BiFunction<MoleculeAtom, MoleculeAtom, Boolean> isArbitrary() {
            return (patternAtom, targetAtom) -> true;
        }

        public static BiFunction<MoleculeAtom, MoleculeAtom, Boolean> isSameElement() {
            return (patternAtom, targetAtom) -> patternAtom.getElement().equals(targetAtom.getElement());
        }
    }
}

