/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.algorithms.graphs.isomorphism.RISubgraphFinder;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimpositionException;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraphs;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentSubstructureSuperimposer
extends SubstructureSuperimposer {
    private static final Logger logger = LoggerFactory.getLogger(FragmentSubstructureSuperimposer.class);
    private static final BiFunction<MoleculeAtom, MoleculeAtom, Boolean> DEFAULT_ATOM_CONDITION = (a, b) -> a.getElement().equals(b.getElement());
    private static final BiFunction<MoleculeBond, MoleculeBond, Boolean> DEFAULT_BOND_CONDITION = (a, b) -> a.getType() == b.getType();
    private final BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition;
    private final BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition;

    private FragmentSubstructureSuperimposer(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition, BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition) {
        super(reference, candidate);
        this.atomCondition = atomCondition;
        this.bondCondition = bondCondition;
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate) throws SubstructureSuperimpositionException {
        return new FragmentSubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_CONDITION, DEFAULT_BOND_CONDITION).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, BiFunction<MoleculeAtom, MoleculeAtom, Boolean> atomCondition, BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition) throws SubstructureSuperimpositionException {
        return new FragmentSubstructureSuperimposer(reference, candidate, atomCondition, bondCondition).calculateSuperimposition();
    }

    @Override
    protected Pair<List<Atom>> defineAtoms() {
        logger.debug("calculating subgraph of fragment alignment");
        ArrayList<Atom> referenceAtoms = new ArrayList<Atom>();
        ArrayList<Atom> candidateAtoms = new ArrayList<Atom>();
        for (int i = 0; i < this.reference.size(); ++i) {
            LeafSubstructure referenceLeafSubstructure = (LeafSubstructure)this.reference.get(i);
            LeafSubstructure candidateLeafSubstructure = (LeafSubstructure)this.candidate.get(i);
            if (!(referenceLeafSubstructure instanceof OakLeafSubstructure) || !(candidateLeafSubstructure instanceof OakLeafSubstructure)) continue;
            MoleculeGraph referenceGraph = MoleculeGraphs.createMoleculeGraphFromStructure((OakLeafSubstructure)referenceLeafSubstructure);
            MoleculeGraph candidateGraph = MoleculeGraphs.createMoleculeGraphFromStructure((OakLeafSubstructure)candidateLeafSubstructure);
            RISubgraphFinder subGraphFinder = referenceGraph.getNodes().size() <= candidateGraph.getNodes().size() ? new RISubgraphFinder((Graph)referenceGraph, (Graph)candidateGraph, this.atomCondition, this.bondCondition) : new RISubgraphFinder((Graph)candidateGraph, (Graph)referenceGraph, this.atomCondition, this.bondCondition);
            if (subGraphFinder.getFullMatches().size() > 1) {
                logger.warn("ambiguous solution found, choosing first one");
            } else if (subGraphFinder.getFullMatches().isEmpty()) {
                logger.error("reference {} against candidate {} has no common subgraph", (Object)this.reference, (Object)this.candidate);
                throw new SubstructureSuperimpositionException("failed to define atoms for alignment, no common subgraph");
            }
            for (Pair moleculeAtomPair : (List)subGraphFinder.getFullMatchPairs().get(0)) {
                referenceAtoms.add(referenceLeafSubstructure.getAtom((Integer)((MoleculeAtom)((Object)moleculeAtomPair.getFirst())).getIdentifier()).orElseThrow(() -> new SubstructureSuperimpositionException("failed to get atoms")));
                candidateAtoms.add(candidateLeafSubstructure.getAtom((Integer)((MoleculeAtom)((Object)moleculeAtomPair.getSecond())).getIdentifier()).orElseThrow(() -> new SubstructureSuperimpositionException("failed to get atoms")));
            }
        }
        return new Pair(referenceAtoms, candidateAtoms);
    }
}

