/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.algorithms.optimization.KuhnMunkres;
import de.bioforscher.singa.mathematics.algorithms.superimposition.VectorSuperimposer;
import de.bioforscher.singa.mathematics.algorithms.superimposition.VectorSuperimposition;
import de.bioforscher.singa.mathematics.combinatorics.StreamPermutations;
import de.bioforscher.singa.mathematics.concepts.Addable;
import de.bioforscher.singa.mathematics.matrices.LabeledMatrix;
import de.bioforscher.singa.mathematics.matrices.LabeledRegularMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimpositionException;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.scores.SubstitutionMatrix;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstructureSuperimposer {
    private static final Logger logger = LoggerFactory.getLogger(SubstructureSuperimposition.class);
    private static final Predicate<Atom> DEFAULT_ATOM_FILTER = StructuralEntityFilter.AtomFilter.isArbitrary();
    protected final List<LeafSubstructure<?>> reference;
    protected final List<LeafSubstructure<?>> candidate;
    private final Predicate<Atom> atomFilter;
    private final RepresentationScheme representationScheme;
    private Vector translation;
    private Matrix rotation;

    private SubstructureSuperimposer(LeafSubstructureContainer reference, LeafSubstructureContainer candidate) {
        this(reference, candidate, StructuralEntityFilter.AtomFilter.isArbitrary(), null);
    }

    private SubstructureSuperimposer(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, Predicate<Atom> atomFilter, RepresentationScheme representationScheme) {
        this.reference = reference.getAllLeafSubstructures();
        this.candidate = candidate.getAllLeafSubstructures();
        this.atomFilter = atomFilter;
        this.representationScheme = representationScheme;
        if (this.reference.size() != this.candidate.size() || this.reference.isEmpty()) {
            throw new IllegalArgumentException("Two lists of substructures cannot be superimposed if they differ in size.");
        }
    }

    private SubstructureSuperimposer(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, Predicate<Atom> atomFilter, RepresentationScheme representationScheme) {
        this.reference = reference;
        this.candidate = candidate;
        this.atomFilter = atomFilter;
        this.representationScheme = representationScheme;
    }

    protected SubstructureSuperimposer(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate) {
        this(reference, candidate, DEFAULT_ATOM_FILTER, null);
    }

    private SubstructureSuperimposer(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, RepresentationScheme representationScheme) {
        this(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme);
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate) {
        return new SubstructureSuperimposer(reference, candidate).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, Predicate<Atom> atomFilter) {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, RepresentationScheme representationScheme) {
        return new SubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate) {
        return new SubstructureSuperimposer(reference, candidate).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, Predicate<Atom> atomFilter) {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateIdealSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, RepresentationScheme representationScheme) {
        return new SubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateIdealSuperimposition();
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, Predicate<Atom> atomFilter, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, RepresentationScheme representationScheme, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, Predicate<Atom> atomFilter, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateKuhnMunkresSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, RepresentationScheme representationScheme, SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        return new SubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateKuhnMunkresSuperimposition(substitutionMatrix, considerExchanges);
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, Predicate<Atom> atomFilter) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, RepresentationScheme representationScheme) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate, representationScheme).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, Predicate<Atom> atomFilter) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate, atomFilter, null).calculateSuperimposition();
    }

    public static SubstructureSuperimposition calculateSubstructureSuperimposition(LeafSubstructureContainer reference, LeafSubstructureContainer candidate, RepresentationScheme representationScheme) throws SubstructureSuperimpositionException {
        return new SubstructureSuperimposer(reference, candidate, DEFAULT_ATOM_FILTER, representationScheme).calculateSuperimposition();
    }

    /*
     * WARNING - void declaration
     */
    protected SubstructureSuperimposition calculateSuperimposition() throws SubstructureSuperimpositionException {
        void var12_16;
        Pair<List<Atom>> alignmentAtoms = this.defineAtoms();
        List referenceAtoms = (List)alignmentAtoms.getFirst();
        List candidateAtoms = (List)alignmentAtoms.getSecond();
        if (referenceAtoms.isEmpty() || candidateAtoms.isEmpty()) {
            logger.error("reference {} against candidate {} has no compatible atom sets: {} {}", new Object[]{this.reference, this.candidate, referenceAtoms, candidateAtoms});
            throw new SubstructureSuperimpositionException("failed to collect per atom alignment sets, no compatible atoms");
        }
        VectorSuperimposition vectorSuperimposition = VectorSuperimposer.calculateVectorSuperimposition(referenceAtoms.stream().map(Atom::getPosition).collect(Collectors.toList()), candidateAtoms.stream().map(Atom::getPosition).collect(Collectors.toList()));
        this.translation = vectorSuperimposition.getTranslation();
        this.rotation = vectorSuperimposition.getRotation();
        double rmsd = vectorSuperimposition.getRmsd();
        List mappedPositions = vectorSuperimposition.getMappedCandidate();
        HashMap<Integer, Integer> positionMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < mappedPositions.size(); ++i) {
            positionMapping.put(((Atom)candidateAtoms.get(i)).getAtomIdentifier(), i);
        }
        ArrayList mappedCandidate = new ArrayList();
        for (LeafSubstructure<?> leafSubstructure : this.candidate) {
            mappedCandidate.add((LeafSubstructure<?>)leafSubstructure.getCopy());
        }
        ArrayList mappedFullCandidate = new ArrayList();
        for (LeafSubstructure<?> leafSubstructure : this.candidate) {
            mappedFullCandidate.add((LeafSubstructure<?>)leafSubstructure.getCopy());
        }
        List list = mappedCandidate.stream().map(subStructure -> subStructure.getAllAtoms().stream().filter(atom -> !positionMapping.containsKey(atom.getAtomIdentifier())).collect(Collectors.toList())).collect(Collectors.toList());
        boolean bl = false;
        while (var12_16 < list.size()) {
            List list2 = (List)list.get((int)var12_16);
            for (Atom atom2 : list2) {
                ((LeafSubstructure)mappedCandidate.get((int)var12_16)).removeAtom(atom2.getAtomIdentifier());
            }
            ++var12_16;
        }
        for (LeafSubstructure leafSubstructure : mappedCandidate) {
            for (Atom atom2 : leafSubstructure.getAllAtoms()) {
                Vector newPosition = (Vector)mappedPositions.get((Integer)positionMapping.get(atom2.getAtomIdentifier()));
                atom2.setPosition((Vector3D)newPosition.as(Vector3D.class));
            }
        }
        mappedFullCandidate.stream().map(AtomContainer::getAllAtoms).flatMap(Collection::stream).forEach(atom -> atom.setPosition((Vector3D)((Vector)this.rotation.transpose().multiply((Vector)atom.getPosition()).add((Addable)this.translation)).as(Vector3D.class)));
        if (logger.isDebugEnabled()) {
            logger.debug("superimposed substructures with RMSD {}{}", (Object)rmsd, (Object)this.toAlignmentString(mappedCandidate, alignmentAtoms));
        }
        return new SubstructureSuperimposition(vectorSuperimposition.getRmsd(), this.translation, this.rotation, this.reference, this.candidate, mappedCandidate, mappedFullCandidate);
    }

    protected Pair<List<Atom>> defineAtoms() {
        List candidateAtoms;
        List referenceAtoms;
        LinkedHashMap perAtomAlignment = new LinkedHashMap();
        IntStream.range(0, this.reference.size()).forEach(i -> {
            Set cfr_ignored_0 = perAtomAlignment.put(new Pair(this.reference.get(i), this.candidate.get(i)), new HashSet());
        });
        perAtomAlignment.entrySet().forEach(this::defineIntersectingAtoms);
        boolean nonMatchingAtoms = perAtomAlignment.values().stream().anyMatch(Set::isEmpty);
        if (nonMatchingAtoms) {
            logger.error("reference {} against candidate {} has no compatible atom strings: {} {}", this.reference, this.candidate);
            throw new SubstructureSuperimpositionException("failed to collect per atom alignment sets, no compatible atoms");
        }
        if (this.representationScheme == null) {
            referenceAtoms = perAtomAlignment.entrySet().stream().flatMap(pairSetEntry -> ((LeafSubstructure)((Pair)pairSetEntry.getKey()).getFirst()).getAllAtoms().stream().filter(this.atomFilter).filter(atom -> ((Set)pairSetEntry.getValue()).contains(atom.getAtomName())).sorted(Comparator.comparing(Atom::getAtomName))).collect(Collectors.toList());
            candidateAtoms = perAtomAlignment.entrySet().stream().flatMap(pairSetEntry -> ((LeafSubstructure)((Pair)pairSetEntry.getKey()).getSecond()).getAllAtoms().stream().filter(this.atomFilter).filter(atom -> ((Set)pairSetEntry.getValue()).contains(atom.getAtomName())).sorted(Comparator.comparing(Atom::getAtomName))).collect(Collectors.toList());
        } else {
            referenceAtoms = perAtomAlignment.entrySet().stream().map(pairSetEntry -> (LeafSubstructure)((Pair)pairSetEntry.getKey()).getFirst()).map(this.representationScheme::determineRepresentingAtom).collect(Collectors.toList());
            candidateAtoms = perAtomAlignment.entrySet().stream().map(pairSetEntry -> (LeafSubstructure)((Pair)pairSetEntry.getKey()).getSecond()).map(this.representationScheme::determineRepresentingAtom).collect(Collectors.toList());
        }
        return new Pair(referenceAtoms, candidateAtoms);
    }

    private void defineIntersectingAtoms(Map.Entry<Pair<LeafSubstructure<?>>, Set<String>> pairListEntry) {
        pairListEntry.getValue().addAll(((LeafSubstructure)pairListEntry.getKey().getFirst()).getAllAtoms().stream().filter(this.atomFilter).map(Atom::getAtomName).collect(Collectors.toSet()));
        pairListEntry.getValue().retainAll(((LeafSubstructure)pairListEntry.getKey().getSecond()).getAllAtoms().stream().filter(this.atomFilter).map(Atom::getAtomName).collect(Collectors.toSet()));
    }

    private SubstructureSuperimposition calculateIdealSuperimposition() throws SubstructureSuperimpositionException {
        Optional<SubstructureSuperimposition> optionalSuperimposition = ((Stream)StreamPermutations.of((Object[])this.candidate.toArray(new LeafSubstructure[0])).parallel()).map(s -> s.collect(Collectors.toList())).map(permutedCandidates -> {
            try {
                return new SubstructureSuperimposer(this.reference, (List<LeafSubstructure<?>>)permutedCandidates, this.atomFilter, this.representationScheme).calculateSuperimposition();
            }
            catch (SubstructureSuperimpositionException e) {
                logger.error("failed to calculate substructure superimposition", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).reduce((s1, s2) -> s1.getRmsd() < s2.getRmsd() ? s1 : s2);
        return optionalSuperimposition.orElseThrow(() -> new SubstructureSuperimpositionException("no ideal superimposition found"));
    }

    private SubstructureSuperimposition calculateKuhnMunkresSuperimposition(SubstitutionMatrix substitutionMatrix, boolean considerExchanges) {
        double[][] costMatrixElements = new double[this.reference.size()][this.candidate.size()];
        for (int i = 0; i < this.reference.size(); ++i) {
            for (int j = i; j < this.candidate.size(); ++j) {
                LeafSubstructure<?> referenceLeafSubstructure = this.reference.get(i);
                LeafSubstructure<?> candidateLeafSubstructure = this.candidate.get(j);
                double substitutionCost = substitutionMatrix.toCostMatrix().getValueForLabel(referenceLeafSubstructure.getFamily(), candidateLeafSubstructure.getFamily());
                if (considerExchanges && !referenceLeafSubstructure.getContainingFamilies().contains(candidateLeafSubstructure.getFamily())) {
                    substitutionCost = Double.MAX_VALUE;
                }
                costMatrixElements[i][j] = substitutionCost;
                costMatrixElements[j][i] = substitutionCost;
            }
        }
        LabeledRegularMatrix costMatrix = new LabeledRegularMatrix(costMatrixElements);
        costMatrix.setRowLabels(this.reference);
        costMatrix.setColumnLabels(this.candidate);
        KuhnMunkres kuhnMunkres = new KuhnMunkres((LabeledMatrix)costMatrix);
        List assignedPairs = kuhnMunkres.getAssignedPairs();
        List<LeafSubstructure<?>> updatedReference = assignedPairs.stream().map(Pair::getFirst).collect(Collectors.toList());
        List<LeafSubstructure<?>> updatedCandidate = assignedPairs.stream().map(Pair::getSecond).collect(Collectors.toList());
        return new SubstructureSuperimposer(updatedReference, updatedCandidate, this.atomFilter, this.representationScheme).calculateSuperimposition();
    }

    private String toAlignmentString(List<LeafSubstructure<?>> mappedCandidate, Pair<List<Atom>> alignmentAtoms) {
        StringJoiner referenceNameJoiner = new StringJoiner("|", "|", "|");
        this.reference.forEach(referenceLeafSubstructure -> referenceNameJoiner.add(String.format("%-100s", referenceLeafSubstructure.toString())));
        StringJoiner atomNameJoiner = new StringJoiner("|", "|", "|");
        for (int i = 0; i < this.reference.size(); ++i) {
            LeafSubstructure<?> referenceLeafSubstructure2 = this.reference.get(i);
            LeafSubstructure<?> candidateLeafSubstructure2 = this.candidate.get(i);
            List referenceAtoms = (List)alignmentAtoms.getFirst();
            referenceAtoms.retainAll(referenceLeafSubstructure2.getAllAtoms());
            List candidateAtoms = (List)alignmentAtoms.getSecond();
            candidateAtoms.retainAll(candidateLeafSubstructure2.getAllAtoms());
            StringJoiner atomStringJoiner = new StringJoiner(" - ");
            for (int j = 0; j < referenceAtoms.size(); ++j) {
                atomStringJoiner.add(((Atom)referenceAtoms.get(j)).getAtomName() + "." + ((Atom)candidateAtoms.get(j)).getAtomName());
            }
            atomNameJoiner.add(String.format("%-100s", atomStringJoiner.toString()));
        }
        StringJoiner candidateNameJoiner = new StringJoiner("|", "|", "|");
        mappedCandidate.forEach(candidateLeafSubstructure -> candidateNameJoiner.add(String.format("%-100s", candidateLeafSubstructure.toString())));
        StringJoiner alignmentJoiner = new StringJoiner("\n", "\n", "");
        alignmentJoiner.add(referenceNameJoiner.toString());
        alignmentJoiner.add(atomNameJoiner.toString());
        alignmentJoiner.add(candidateNameJoiner.toString());
        return alignmentJoiner.toString();
    }
}

