/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition;

import de.bioforscher.singa.mathematics.algorithms.superimposition.Superimposition;
import de.bioforscher.singa.mathematics.concepts.Addable;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SubstructureSuperimposition
implements Superimposition<LeafSubstructure<?>> {
    private final double rmsd;
    private final Vector translation;
    private final Matrix rotation;
    private final List<LeafSubstructure<?>> reference;
    private final List<LeafSubstructure<?>> candidate;
    private final List<LeafSubstructure<?>> mappedCandidate;
    private final List<LeafSubstructure<?>> mappedFullCandidate;

    public SubstructureSuperimposition(double rmsd, Vector translation, Matrix rotation, List<LeafSubstructure<?>> reference, List<LeafSubstructure<?>> candidate, List<LeafSubstructure<?>> mappedCandidate, List<LeafSubstructure<?>> mappedFullCandidate) {
        this.rmsd = rmsd;
        this.translation = translation;
        this.rotation = rotation;
        this.reference = reference;
        this.candidate = candidate;
        this.mappedCandidate = mappedCandidate;
        this.mappedFullCandidate = mappedFullCandidate;
    }

    public List<LeafSubstructure<?>> getReference() {
        return this.reference;
    }

    public List<LeafSubstructure<?>> getCandidate() {
        return this.candidate;
    }

    public String getStringRepresentation() {
        return this.mappedCandidate.stream().map(leafSubstructure -> leafSubstructure.getChainIdentifier() + "-" + leafSubstructure.getIdentifier().getSerial() + (leafSubstructure.getInsertionCode() != '\u0000' ? Character.valueOf(leafSubstructure.getInsertionCode()) : "")).collect(Collectors.joining("_", this.getFormattedRmsd() + "_" + this.mappedCandidate.get(0).getPdbIdentifier() + "_", ""));
    }

    public String toString() {
        return "SubstructureSuperimposition{rmsd=" + this.rmsd + '}';
    }

    public double getRmsd() {
        return this.rmsd;
    }

    public Vector getTranslation() {
        return this.translation;
    }

    public Matrix getRotation() {
        return this.rotation;
    }

    public List<LeafSubstructure<?>> getMappedCandidate() {
        return this.mappedCandidate;
    }

    public List<LeafSubstructure<?>> getMappedFullCandidate() {
        return this.mappedFullCandidate;
    }

    public List<LeafSubstructure<?>> applyTo(List<LeafSubstructure<?>> candidate) {
        ArrayList copyOfCandidate = new ArrayList();
        for (LeafSubstructure<?> leafSubstructure : candidate) {
            copyOfCandidate.add((LeafSubstructure<?>)leafSubstructure.getCopy());
        }
        copyOfCandidate.stream().map(AtomContainer::getAllAtoms).flatMap(Collection::stream).forEach(atom -> atom.setPosition((Vector3D)((Vector)this.rotation.transpose().multiply((Vector)atom.getPosition()).add((Addable)this.translation)).as(Vector3D.class)));
        return copyOfCandidate;
    }
}

