/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.consensus;

import de.bioforscher.singa.structure.algorithms.superimposition.consensus.ConsensusAlignment;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import java.util.List;
import java.util.function.Predicate;

public class ConsensusBuilder {
    private static final double DEFAULT_CLUSTER_CUTOFF = 0.5;
    private static final boolean DEFAULT_ALIGN_WITHIN_CLUSTERS = true;
    private static final Predicate<Atom> DEFAULT_ATOM_FILTER = StructuralEntityFilter.AtomFilter.isArbitrary();
    private static final RepresentationSchemeType DEFAULT_REPRESENTATION_SCHEME_TYPE = null;
    private static final boolean DEFAULT_IDEAL_SUPERIMPOSITION = false;

    private ConsensusBuilder() {
    }

    public static InputStep create() {
        return new Builder();
    }

    static /* synthetic */ RepresentationSchemeType access$000() {
        return DEFAULT_REPRESENTATION_SCHEME_TYPE;
    }

    static /* synthetic */ Predicate access$100() {
        return DEFAULT_ATOM_FILTER;
    }

    public static class Builder
    implements InputStep,
    AtomStep,
    ParameterStep {
        List<StructuralMotif> structuralMotifs;
        RepresentationSchemeType representationSchemeType = ConsensusBuilder.access$000();
        Predicate<Atom> atomFilter = ConsensusBuilder.access$100();
        double clusterCutoff = 0.5;
        boolean idealSuperimposition = false;
        boolean alignWithinClusters = true;

        @Override
        public AtomStep inputStructuralMotifs(List<StructuralMotif> structuralMotifs) {
            this.structuralMotifs = structuralMotifs;
            return this;
        }

        @Override
        public ParameterStep representationSchemeType(RepresentationSchemeType representationSchemeType) {
            this.representationSchemeType = representationSchemeType;
            return this;
        }

        @Override
        public ParameterStep atomFilter(Predicate<Atom> atomFilter) {
            this.atomFilter = atomFilter;
            return this;
        }

        @Override
        public ConsensusAlignment run() {
            return new ConsensusAlignment(this);
        }

        @Override
        public ParameterStep clusterCutoff(double clusterCutoff) {
            this.clusterCutoff = clusterCutoff;
            return this;
        }

        @Override
        public ParameterStep idealSuperimposition(boolean idealSuperimposition) {
            this.idealSuperimposition = idealSuperimposition;
            return this;
        }

        @Override
        public ParameterStep alignWithinClusters(boolean alignWithinClusters) {
            this.alignWithinClusters = alignWithinClusters;
            return this;
        }
    }

    public static interface ParameterStep {
        public ConsensusAlignment run();

        public ParameterStep clusterCutoff(double var1);

        public ParameterStep idealSuperimposition(boolean var1);

        public ParameterStep alignWithinClusters(boolean var1);
    }

    public static interface AtomStep {
        public ParameterStep representationSchemeType(RepresentationSchemeType var1);

        public ParameterStep atomFilter(Predicate<Atom> var1);

        public ConsensusAlignment run();
    }

    public static interface InputStep {
        public AtomStep inputStructuralMotifs(List<StructuralMotif> var1);
    }
}

