/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d;

import de.bioforscher.singa.core.utility.CommutablePair;
import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.features.identifiers.ECNumber;
import de.bioforscher.singa.features.identifiers.PfamIdentifier;
import de.bioforscher.singa.features.identifiers.UniProtIdentifier;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3D;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DBuilder;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DException;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DMatch;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.ValidAlignmentGenerator;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.ValidCandidateGenerator;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics.FofanovEstimation;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics.StatisticalModel;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import de.bioforscher.singa.structure.parser.sifts.PDBEnzymeMapper;
import de.bioforscher.singa.structure.parser.sifts.PDBPfamMapper;
import de.bioforscher.singa.structure.parser.sifts.PDBUniProtMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fit3DAlignment
implements Fit3D {
    private static final Logger logger = LoggerFactory.getLogger(Fit3DAlignment.class);
    private final StructuralMotif queryMotif;
    private final LeafSubstructureContainer target;
    private final double squaredDistanceTolerance;
    private final RepresentationScheme representationScheme;
    private final StatisticalModel statisticalModel;
    private final double rmsdCutoff;
    private final Predicate<Atom> atomFilter;
    private final boolean mapEcNumbers;
    private final boolean mapPfamIdentifiers;
    private final boolean mapUniProtIdentifiers;
    private final boolean filterEnvironments;
    private LabeledSymmetricMatrix<LeafSubstructure<?>> queryMotifSquaredDistanceMatrix;
    private double squaredQueryExtent;
    private List<CommutablePair<LeafSubstructure<?>>> queryMotifPairs;
    private LabeledSymmetricMatrix<LeafSubstructure<?>> squaredDistanceMatrix;
    private List<List<LeafSubstructure<?>>> environments;
    private HashMap<List<LeafSubstructure<?>>, Set<Set<LeafSubstructure<?>>>> candidates;
    private List<Fit3DMatch> matches;

    Fit3DAlignment(Fit3DBuilder.Builder builder) {
        this.queryMotif = builder.queryMotif.getCopy();
        this.target = builder.target.getCopy();
        this.rmsdCutoff = builder.rmsdCutoff;
        this.squaredDistanceTolerance = builder.distanceTolerance * builder.distanceTolerance;
        this.atomFilter = builder.atomFilter;
        this.representationScheme = builder.representationScheme;
        this.statisticalModel = builder.statisticalModel;
        this.mapUniProtIdentifiers = builder.mapUniprotIdentifiers;
        this.mapPfamIdentifiers = builder.mapPfamIdentifiers;
        this.mapEcNumbers = builder.mapEcNumbers;
        this.filterEnvironments = builder.filterEnvironments;
        if (this.queryMotif.size() > this.target.getNumberOfLeafSubstructures()) {
            throw new Fit3DException("search target " + this.target + " must contain at least as many atom-containing substructures as the query motif");
        }
        this.environments = new ArrayList();
        this.matches = new ArrayList<Fit3DMatch>();
        this.candidates = new HashMap();
        logger.debug("computing Fit3D alignment of motif {} against {}", (Object)this.queryMotif, (Object)this.target);
        this.target.removeLeafSubstructuresNotRelevantFor(this.queryMotif);
        if (this.queryMotif.size() > this.target.getNumberOfLeafSubstructures()) {
            logger.debug("reduced target structure smaller than query motif, no matches can be found");
            return;
        }
        this.queryMotifSquaredDistanceMatrix = VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(this.queryMotif.getAllLeafSubstructures(), LeafSubstructure::getPosition);
        Pair positionOfMaximalElement = (Pair)Matrices.getPositionsOfMaximalElement(this.queryMotifSquaredDistanceMatrix).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("could not determine the maximal squared extent of " + this.queryMotif));
        this.squaredQueryExtent = this.queryMotifSquaredDistanceMatrix.getElement(((Integer)positionOfMaximalElement.getFirst()).intValue(), ((Integer)positionOfMaximalElement.getSecond()).intValue());
        logger.debug("the squared query motif extent is {}", (Object)this.squaredQueryExtent);
        if (this.filterEnvironments) {
            this.queryMotifPairs = new ArrayList();
            for (int i = 0; i < this.queryMotif.getAllLeafSubstructures().size(); ++i) {
                for (int j = i + 1; j < this.queryMotif.getAllLeafSubstructures().size(); ++j) {
                    CommutablePair queryMotifPair = new CommutablePair(this.queryMotif.getAllLeafSubstructures().get(i), this.queryMotif.getAllLeafSubstructures().get(j));
                    this.queryMotifPairs.add(queryMotifPair);
                }
            }
        }
        this.squaredDistanceMatrix = VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(this.target.getAllLeafSubstructures(), LeafSubstructure::getPosition);
        this.composeEnvironments();
        this.generateCandidates();
        this.computeMatches();
        this.calculateStatistics();
        this.mapIdentifiers();
    }

    private void calculateStatistics() {
        if (this.statisticalModel != null && this.statisticalModel instanceof FofanovEstimation) {
            if (!this.matches.isEmpty()) {
                logger.debug("match found, increasing GS count for Fofanov model");
                ((FofanovEstimation)this.statisticalModel).incrementGs();
            } else if (!this.candidates.isEmpty()) {
                logger.debug("no match found, but theoretically possible, increasing NS");
                ((FofanovEstimation)this.statisticalModel).incrementNs();
            }
        }
    }

    private void mapIdentifiers() {
        if (this.mapUniProtIdentifiers || this.mapPfamIdentifiers || this.mapEcNumbers) {
            logger.debug("mapping identifiers for matches: UniProt: {}, Pfam: {}, EC: {}", new Object[]{this.mapUniProtIdentifiers, this.mapPfamIdentifiers, this.mapEcNumbers});
            this.matches.forEach(match -> {
                String pdbIdentifier = match.getSubstructureSuperimposition().getCandidate().get(0).getPdbIdentifier();
                List chainIdentifiers = match.getSubstructureSuperimposition().getCandidate().stream().map(LeafSubstructure::getChainIdentifier).distinct().collect(Collectors.toList());
                if (this.mapUniProtIdentifiers) {
                    Map<String, UniProtIdentifier> uniProtIdentifiers = PDBUniProtMapper.map(pdbIdentifier);
                    uniProtIdentifiers.keySet().retainAll(chainIdentifiers);
                    if (!uniProtIdentifiers.isEmpty()) {
                        match.setUniProtIdentifiers(uniProtIdentifiers);
                    }
                }
                if (this.mapPfamIdentifiers) {
                    Map<String, PfamIdentifier> pfamIdentifiers = PDBPfamMapper.map(pdbIdentifier);
                    pfamIdentifiers.keySet().retainAll(chainIdentifiers);
                    if (!pfamIdentifiers.isEmpty()) {
                        match.setPfamIdentifiers(pfamIdentifiers);
                    }
                }
                if (this.mapEcNumbers) {
                    Map<String, ECNumber> ecNumbers = PDBEnzymeMapper.map(pdbIdentifier);
                    ecNumbers.keySet().retainAll(chainIdentifiers);
                    if (!ecNumbers.isEmpty()) {
                        match.setEcNumbers(ecNumbers);
                    }
                }
            });
            if (this.target instanceof Structure) {
                this.matches.forEach(match -> match.setStructureTitle(((Structure)this.target).getTitle()));
            }
        }
    }

    @Override
    public List<Fit3DMatch> getMatches() {
        return this.matches;
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    private void computeMatches() {
        this.candidates.values().stream().flatMap(Collection::stream).forEach(this::computeAlignments);
        Collections.sort(this.matches);
    }

    private void computeAlignments(Set<LeafSubstructure<?>> leafSubstructures) {
        boolean redundant = this.matches.stream().filter(match -> match.getSubstructureSuperimposition() != null).anyMatch(match -> match.getSubstructureSuperimposition().getCandidate().containsAll(leafSubstructures));
        if (redundant) {
            logger.trace("redundant candidate {} skipped", leafSubstructures);
            return;
        }
        ValidAlignmentGenerator validAlignmentGenerator = new ValidAlignmentGenerator(this.queryMotif.getAllLeafSubstructures(), new ArrayList(leafSubstructures));
        List<List<Pair<LeafSubstructure<?>>>> validAlignments = validAlignmentGenerator.getValidAlignments();
        for (List<Pair<LeafSubstructure<?>>> validAlignment : validAlignments) {
            List<LeafSubstructure<?>> alignmentCandidate = validAlignment.stream().map(Pair::getSecond).collect(Collectors.toList());
            SubstructureSuperimposition superimposition = this.representationScheme != null ? SubstructureSuperimposer.calculateSubstructureSuperimposition(this.queryMotif.getAllLeafSubstructures(), alignmentCandidate, this.representationScheme) : SubstructureSuperimposer.calculateSubstructureSuperimposition(this.queryMotif.getAllLeafSubstructures(), alignmentCandidate, this.atomFilter);
            if (!(superimposition.getRmsd() <= this.rmsdCutoff)) continue;
            if (this.statisticalModel != null && this.statisticalModel instanceof FofanovEstimation) {
                if (superimposition.getRmsd() <= ((FofanovEstimation)this.statisticalModel).getModelCorrectnessCutoff()) {
                    this.matches.add(Fit3DMatch.of(superimposition.getRmsd(), superimposition));
                    continue;
                }
                boolean redundantRmsd = this.matches.stream().anyMatch(match -> match.getRmsd() == superimposition.getRmsd());
                if (redundantRmsd) continue;
                this.matches.add(Fit3DMatch.of(superimposition.getRmsd()));
                continue;
            }
            this.matches.add(Fit3DMatch.of(superimposition.getRmsd(), superimposition));
        }
    }

    private void generateCandidates() {
        for (List<LeafSubstructure<?>> environment : this.environments) {
            Set<Set<LeafSubstructure<?>>> currentCandidates = new ValidCandidateGenerator(this.queryMotif.getAllLeafSubstructures(), environment).getValidCandidates();
            if (currentCandidates.isEmpty()) continue;
            this.candidates.put(environment, currentCandidates);
        }
    }

    private void composeEnvironments() {
        for (LeafSubstructure<?> currentSubstructure : this.target.getAllLeafSubstructures()) {
            RegularVector distanceToOthers = this.squaredDistanceMatrix.getColumnByLabel(currentSubstructure);
            ArrayList environment = new ArrayList();
            for (int i = 0; i < distanceToOthers.getElements().length; ++i) {
                double currentDistance = distanceToOthers.getElement(i);
                if (!(currentDistance <= this.squaredQueryExtent + this.squaredDistanceTolerance)) continue;
                environment.add((LeafSubstructure<?>)this.squaredDistanceMatrix.getColumnLabel(i));
            }
            if (environment.size() < this.queryMotif.size()) continue;
            logger.debug("possible environment {} within around {} added", environment, currentSubstructure);
            if (this.filterEnvironments && this.filterEnvironment(environment)) {
                this.environments.add(environment);
                continue;
            }
            this.environments.add(environment);
        }
    }

    private boolean filterEnvironment(List<LeafSubstructure<?>> environment) {
        ArrayList<CommutablePair> environmentPairs = new ArrayList<CommutablePair>();
        for (int i = 0; i < environment.size(); ++i) {
            for (int j = i + 1; j < environment.size(); ++j) {
                environmentPairs.add(new CommutablePair(environment.get(i), environment.get(j)));
            }
        }
        for (CommutablePair<LeafSubstructure<?>> queryMotifPair : this.queryMotifPairs) {
            double queryMotifPairDistance = this.queryMotifSquaredDistanceMatrix.getValueForLabel(queryMotifPair.getFirst(), queryMotifPair.getSecond());
            List compatiblePairs = environmentPairs.stream().filter(environmentPair -> ((LeafSubstructure)queryMotifPair.getFirst()).getExchangeableFamilies().contains(((LeafSubstructure)environmentPair.getFirst()).getFamily()) || ((LeafSubstructure)queryMotifPair.getSecond()).getExchangeableFamilies().contains(((LeafSubstructure)environmentPair.getSecond()).getFamily()) || ((LeafSubstructure)queryMotifPair.getFirst()).getFamily() == ((LeafSubstructure)environmentPair.getFirst()).getFamily() || ((LeafSubstructure)queryMotifPair.getFirst()).getFamily() == ((LeafSubstructure)environmentPair.getSecond()).getFamily()).filter(environmentPair -> ((LeafSubstructure)queryMotifPair.getSecond()).getExchangeableFamilies().contains(((LeafSubstructure)environmentPair.getSecond()).getFamily()) || ((LeafSubstructure)queryMotifPair.getSecond()).getExchangeableFamilies().contains(((LeafSubstructure)environmentPair.getFirst()).getFamily()) || ((LeafSubstructure)queryMotifPair.getSecond()).getFamily() == ((LeafSubstructure)environmentPair.getSecond()).getFamily() || ((LeafSubstructure)queryMotifPair.getSecond()).getFamily() == ((LeafSubstructure)environmentPair.getFirst()).getFamily()).collect(Collectors.toList());
            boolean hasCompatiblePair = false;
            for (CommutablePair compatiblePair : compatiblePairs) {
                double compatiblePairDistance = this.squaredDistanceMatrix.getValueForLabel(compatiblePair.getFirst(), compatiblePair.getSecond());
                if (!(compatiblePairDistance >= queryMotifPairDistance - this.squaredDistanceTolerance) || !(compatiblePairDistance <= queryMotifPairDistance + this.squaredDistanceTolerance)) continue;
                hasCompatiblePair = true;
            }
            if (hasCompatiblePair) continue;
            return false;
        }
        return true;
    }
}

