/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d;

import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3D;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DBuilder;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DMatch;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics.StatisticalModel;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import de.bioforscher.singa.structure.model.oak.Structures;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fit3DAlignmentBatch
implements Fit3D {
    private static final Logger logger = LoggerFactory.getLogger(Fit3DAlignmentBatch.class);
    private final StructuralMotif queryMotif;
    private final Predicate<Atom> atomFilter;
    private final RepresentationScheme representationScheme;
    private final int parallelism;
    private final double rmsdCutoff;
    private final double distanceTolerance;
    private final ExecutorService executorService;
    private final StructureParser.MultiParser multiParser;
    private final boolean skipAlphaCarbonTargets;
    private final boolean skipBackboneTargets;
    private final StatisticalModel statisticalModel;
    private final boolean mapUniprotIdentifiers;
    private final boolean mapPfamIdentifiers;
    private final boolean mapEcNumbers;
    private final boolean filterEnvironments;
    private List<Fit3DMatch> allMatches;

    Fit3DAlignmentBatch(Fit3DBuilder.Builder builder) {
        this.queryMotif = builder.queryMotif;
        this.multiParser = builder.multiParser;
        this.parallelism = builder.parallelism;
        this.skipAlphaCarbonTargets = builder.skipAlphaCarbonTargets;
        this.skipBackboneTargets = builder.skipBackboneTargets;
        this.executorService = Executors.newWorkStealingPool(this.parallelism);
        this.atomFilter = builder.atomFilter;
        this.representationScheme = builder.representationScheme;
        this.rmsdCutoff = builder.rmsdCutoff;
        this.distanceTolerance = builder.distanceTolerance;
        this.statisticalModel = builder.statisticalModel;
        this.mapUniprotIdentifiers = builder.mapUniprotIdentifiers;
        this.mapPfamIdentifiers = builder.mapPfamIdentifiers;
        this.mapEcNumbers = builder.mapEcNumbers;
        this.filterEnvironments = builder.filterEnvironments;
        logger.info("Fit3D alignment batch initialized with {} target structures", (Object)this.multiParser.getNumberOfQueuedStructures());
        this.computeAlignments();
        logger.info("found {} matches in {} target structures", (Object)this.allMatches.size(), (Object)this.multiParser.getNumberOfQueuedStructures());
    }

    private void computeAlignments() {
        ArrayList<Fit3DCalculator> jobs = new ArrayList<Fit3DCalculator>();
        for (int i = 0; i < this.multiParser.getNumberOfQueuedStructures(); ++i) {
            jobs.add(new Fit3DCalculator());
        }
        try {
            this.allMatches = this.executorService.invokeAll(jobs).stream().map(future -> {
                try {
                    return (List)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Ft3D parallel execution failed", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            logger.error("Ft3D parallel execution failed", (Throwable)e);
        }
        Collections.sort(this.allMatches);
        if (this.statisticalModel != null) {
            try {
                this.statisticalModel.calculatePvalues(this.allMatches);
            }
            catch (Exception e) {
                logger.warn("failed to calculate p-values", (Throwable)e);
            }
        }
    }

    @Override
    public List<Fit3DMatch> getMatches() {
        return this.allMatches;
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    private class Fit3DCalculator
    implements Callable<List<Fit3DMatch>> {
        private Fit3DCalculator() {
        }

        @Override
        public List<Fit3DMatch> call() {
            if (Fit3DAlignmentBatch.this.multiParser.hasNext()) {
                Structure structure = null;
                try {
                    structure = Fit3DAlignmentBatch.this.multiParser.next();
                    if (Fit3DAlignmentBatch.this.skipAlphaCarbonTargets && Structures.isAlphaCarbonStructure(structure)) {
                        logger.info("ignored alpha carbon only structure {}", (Object)structure);
                        return null;
                    }
                    if (Fit3DAlignmentBatch.this.skipBackboneTargets && Structures.isBackboneStructure(structure)) {
                        logger.info("ignored backbone only structure {}", (Object)structure);
                        return null;
                    }
                    Model target = structure.getFirstModel();
                    logger.info("computing Fit3D alignment against {}", (Object)target);
                    Fit3DBuilder.ParameterStep parameterStep = Fit3DAlignmentBatch.this.representationScheme == null ? Fit3DBuilder.create().query(Fit3DAlignmentBatch.this.queryMotif).target(target).atomFilter(Fit3DAlignmentBatch.this.atomFilter).rmsdCutoff(Fit3DAlignmentBatch.this.rmsdCutoff).distanceTolerance(Fit3DAlignmentBatch.this.distanceTolerance) : Fit3DBuilder.create().query(Fit3DAlignmentBatch.this.queryMotif).target(target).representationScheme(Fit3DAlignmentBatch.this.representationScheme.getType()).rmsdCutoff(Fit3DAlignmentBatch.this.rmsdCutoff).distanceTolerance(Fit3DAlignmentBatch.this.distanceTolerance);
                    if (Fit3DAlignmentBatch.this.statisticalModel != null) {
                        parameterStep.statisticalModel(Fit3DAlignmentBatch.this.statisticalModel);
                    }
                    if (Fit3DAlignmentBatch.this.mapUniprotIdentifiers) {
                        parameterStep.mapUniProtIdentifiers();
                    }
                    if (Fit3DAlignmentBatch.this.mapPfamIdentifiers) {
                        parameterStep.mapPfamIdentifiers();
                    }
                    if (Fit3DAlignmentBatch.this.mapEcNumbers) {
                        parameterStep.mapECNumbers();
                    }
                    if (Fit3DAlignmentBatch.this.filterEnvironments) {
                        parameterStep.filterEnvironments();
                    }
                    Fit3D fit3d = parameterStep.run();
                    List<Fit3DMatch> matches = fit3d.getMatches();
                    for (Fit3DMatch match : matches) {
                        match.setStructureTitle(structure.getTitle());
                    }
                    return matches;
                }
                catch (Exception e) {
                    if (structure != null) {
                        logger.warn("failed to run Fit3D against structure {}", (Object)structure, (Object)e);
                    }
                    logger.warn("failed to run Fit3D", (Throwable)e);
                }
            }
            return null;
        }
    }
}

