/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d;

import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimpositionException;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3D;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DAlignment;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DAlignmentBatch;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DException;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DSiteAlignment;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeFactory;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics.StatisticalModel;
import de.bioforscher.singa.structure.algorithms.superimposition.scores.SubstitutionMatrix;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import java.util.Objects;
import java.util.function.Predicate;

public class Fit3DBuilder {
    private static final double DEFAULT_DISTANCE_TOLERANCE = 1.0;
    private static final double DEFAULT_RMSD_CUTOFF = 2.5;
    private static final Predicate<Atom> DEFAULT_ATOM_FILTER = StructuralEntityFilter.AtomFilter.isArbitrary();
    private static final double DEFAULT_CUTOFF_SCORE = 5.0;
    private static final SubstitutionMatrix DEFAULT_SUBSTITUTION_MATRIX = SubstitutionMatrix.BLOSUM_45;

    private Fit3DBuilder() {
    }

    public static QueryStep create() {
        return new Builder();
    }

    static /* synthetic */ Predicate access$000() {
        return DEFAULT_ATOM_FILTER;
    }

    static /* synthetic */ SubstitutionMatrix access$100() {
        return DEFAULT_SUBSTITUTION_MATRIX;
    }

    public static class Builder
    implements QueryStep,
    SiteStep,
    SiteParameterConfigurationStep,
    SiteConfigurationStep,
    TargetStep,
    AtomStep,
    BatchParameterStep,
    ParameterStep {
        StructuralMotif queryMotif;
        StructureParser.MultiParser multiParser;
        LeafSubstructureContainer target;
        int parallelism;
        double rmsdCutoff = 2.5;
        double distanceTolerance = 1.0;
        Predicate<Atom> atomFilter = Fit3DBuilder.access$000();
        RepresentationScheme representationScheme;
        StructuralMotif site1;
        StructuralMotif site2;
        double cutoffScore = 5.0;
        boolean exhaustive;
        boolean restrictToExchanges;
        boolean kuhnMunkres;
        SubstitutionMatrix substitutionMatrix = Fit3DBuilder.access$100();
        boolean skipAlphaCarbonTargets;
        boolean skipBackboneTargets;
        StatisticalModel statisticalModel;
        boolean mapUniprotIdentifiers;
        boolean mapPfamIdentifiers;
        boolean mapEcNumbers;
        boolean filterEnvironments;

        @Override
        public TargetStep query(StructuralMotif query) {
            Objects.requireNonNull(query);
            this.queryMotif = query;
            return this;
        }

        @Override
        public SiteStep site(StructuralMotif site1) {
            Objects.requireNonNull(site1);
            this.site1 = site1;
            return this;
        }

        @Override
        public AtomStep target(LeafSubstructureContainer target) {
            Objects.requireNonNull(target);
            this.target = target;
            return this;
        }

        @Override
        public BatchParameterStep targets(StructureParser.MultiParser multiParser) {
            Objects.requireNonNull(multiParser);
            this.multiParser = multiParser;
            return this;
        }

        @Override
        public Fit3D run() throws SubstructureSuperimpositionException {
            if (this.multiParser != null) {
                return new Fit3DAlignmentBatch(this);
            }
            if (this.site1 != null && this.site2 != null) {
                return new Fit3DSiteAlignment(this);
            }
            return new Fit3DAlignment(this);
        }

        @Override
        public ParameterStep rmsdCutoff(double rmsdCutoff) {
            if (rmsdCutoff <= 0.0) {
                throw new Fit3DException("RMSD cutoff must be positive");
            }
            this.rmsdCutoff = rmsdCutoff;
            return this;
        }

        @Override
        public ParameterStep distanceTolerance(double distanceTolerance) {
            if (distanceTolerance <= 0.0) {
                throw new Fit3DException("distance tolerance cutoff must be positive");
            }
            this.distanceTolerance = distanceTolerance;
            return this;
        }

        @Override
        public ParameterStep atomFilter(Predicate<Atom> atomFilter) {
            Objects.requireNonNull(atomFilter);
            this.atomFilter = atomFilter;
            return this;
        }

        @Override
        public ParameterStep representationScheme(RepresentationSchemeType representationSchemeType) {
            Objects.requireNonNull(representationSchemeType);
            this.representationScheme = RepresentationSchemeFactory.createRepresentationScheme(representationSchemeType);
            return this;
        }

        @Override
        public AtomStep limitedParallelism(int limitedParallelism) {
            if ((double)limitedParallelism <= 0.0) {
                throw new Fit3DException("level of parallelism for batch calculation must be positive");
            }
            this.parallelism = limitedParallelism;
            return this;
        }

        @Override
        public AtomStep maximalParallelism() {
            this.parallelism = Runtime.getRuntime().availableProcessors();
            return this;
        }

        @Override
        public BatchParameterStep skipAlphaCarbonTargets() {
            this.skipAlphaCarbonTargets = true;
            return this;
        }

        @Override
        public BatchParameterStep skipBackboneTargets() {
            this.skipBackboneTargets = true;
            return this;
        }

        @Override
        public ParameterStep statisticalModel(StatisticalModel statisticalModel) {
            Objects.requireNonNull(statisticalModel);
            this.statisticalModel = statisticalModel;
            return this;
        }

        @Override
        public ParameterStep mapUniProtIdentifiers() {
            this.mapUniprotIdentifiers = true;
            return this;
        }

        @Override
        public ParameterStep mapPfamIdentifiers() {
            this.mapPfamIdentifiers = true;
            return this;
        }

        @Override
        public ParameterStep mapECNumbers() {
            this.mapEcNumbers = true;
            return this;
        }

        @Override
        public ParameterStep filterEnvironments() {
            this.filterEnvironments = true;
            return this;
        }

        @Override
        public SiteParameterConfigurationStep vs(StructuralMotif site2) {
            Objects.requireNonNull(site2);
            this.site2 = site2;
            return this;
        }

        @Override
        public SiteParameterConfigurationStep cutoffScore(double cutoffScore) {
            this.cutoffScore = cutoffScore;
            return this;
        }

        @Override
        public SiteParameterConfigurationStep substitutionMatrix(SubstitutionMatrix substitutionMatrix) {
            this.substitutionMatrix = substitutionMatrix;
            return this;
        }

        @Override
        public AtomStep restrictToSpecifiedExchanges() {
            this.restrictToExchanges = true;
            return this;
        }

        @Override
        public AtomStep ignoreSpecifiedExchanges() {
            this.restrictToExchanges = false;
            return this;
        }

        @Override
        public AtomStep exhaustive() {
            this.exhaustive = true;
            return this;
        }

        @Override
        public AtomStep kuhnMunkres(SubstitutionMatrix substitutionMatrix, boolean restrictToExchanges) {
            this.kuhnMunkres = true;
            this.substitutionMatrix = substitutionMatrix;
            if (restrictToExchanges) {
                this.restrictToExchanges = true;
            }
            return this;
        }
    }

    public static interface ParameterStep {
        public Fit3D run() throws SubstructureSuperimpositionException;

        public ParameterStep rmsdCutoff(double var1);

        public ParameterStep distanceTolerance(double var1);

        public ParameterStep statisticalModel(StatisticalModel var1);

        public ParameterStep mapUniProtIdentifiers();

        public ParameterStep mapPfamIdentifiers();

        public ParameterStep mapECNumbers();

        public ParameterStep filterEnvironments();
    }

    public static interface AtomStep {
        public Fit3D run() throws SubstructureSuperimpositionException;

        public ParameterStep atomFilter(Predicate<Atom> var1);

        public ParameterStep representationScheme(RepresentationSchemeType var1);
    }

    public static interface BatchParameterStep {
        public AtomStep limitedParallelism(int var1);

        public AtomStep maximalParallelism();

        public BatchParameterStep skipAlphaCarbonTargets();

        public BatchParameterStep skipBackboneTargets();
    }

    public static interface TargetStep {
        public AtomStep target(LeafSubstructureContainer var1);

        public BatchParameterStep targets(StructureParser.MultiParser var1);
    }

    public static interface SiteParameterConfigurationStep
    extends SiteConfigurationStep {
        public SiteParameterConfigurationStep cutoffScore(double var1);

        public SiteParameterConfigurationStep substitutionMatrix(SubstitutionMatrix var1);
    }

    public static interface SiteConfigurationStep {
        public AtomStep restrictToSpecifiedExchanges();

        public AtomStep ignoreSpecifiedExchanges();

        public AtomStep exhaustive();

        public AtomStep kuhnMunkres(SubstitutionMatrix var1, boolean var2);
    }

    public static interface SiteStep {
        public SiteParameterConfigurationStep vs(StructuralMotif var1);
    }

    public static interface QueryStep {
        public TargetStep query(StructuralMotif var1);

        public SiteStep site(StructuralMotif var1);
    }
}

