/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d;

import de.bioforscher.singa.features.identifiers.ECNumber;
import de.bioforscher.singa.features.identifiers.PfamIdentifier;
import de.bioforscher.singa.features.identifiers.UniProtIdentifier;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.model.oak.StructuralMotif;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class Fit3DMatch
implements Comparable<Fit3DMatch> {
    public static final String CSV_HEADER = "match,rmsd,p-value,title,UniProt,Pfam,EC\n";
    private final SubstructureSuperimposition substructureSuperimposition;
    private final double rmsd;
    private double pvalue;
    private StructuralMotif candidateMotif;
    private StructuralMotif.Type matchType;
    private Map<String, UniProtIdentifier> uniProtIdentifiers;
    private Map<String, PfamIdentifier> pfamIdentifiers;
    private Map<String, ECNumber> ecNumbers;
    private String alignedSequence;
    private String structureTitle;

    private Fit3DMatch(double rmsd, SubstructureSuperimposition substructureSuperimposition, double pvalue) {
        this.rmsd = rmsd;
        this.substructureSuperimposition = substructureSuperimposition;
        this.pvalue = pvalue;
        if (substructureSuperimposition != null) {
            this.analyzeMatch();
        }
    }

    public static Fit3DMatch of(double rmsd) {
        return new Fit3DMatch(rmsd, null, Double.NaN);
    }

    public static Fit3DMatch of(double rmsd, SubstructureSuperimposition substructureSuperimposition) {
        return new Fit3DMatch(rmsd, substructureSuperimposition, Double.NaN);
    }

    public static Fit3DMatch of(double rmsd, SubstructureSuperimposition substructureSuperimposition, double pvalue) {
        return new Fit3DMatch(rmsd, substructureSuperimposition, pvalue);
    }

    private void analyzeMatch() {
        this.alignedSequence = this.substructureSuperimposition.getMappedCandidate().stream().map(leafSubstructure -> leafSubstructure.getFamily().getOneLetterCode()).collect(Collectors.joining(""));
        this.candidateMotif = StructuralMotif.fromLeafSubstructures(this.substructureSuperimposition.getMappedFullCandidate());
        this.matchType = StructuralMotif.Type.determine(this.candidateMotif);
    }

    public String getAlignedSequence() {
        return this.alignedSequence;
    }

    public StructuralMotif getCandidateMotif() {
        return this.candidateMotif;
    }

    public StructuralMotif.Type getMatchType() {
        return this.matchType;
    }

    public Optional<Map<String, UniProtIdentifier>> getUniProtIdentifiers() {
        return Optional.ofNullable(this.uniProtIdentifiers);
    }

    void setUniProtIdentifiers(Map<String, UniProtIdentifier> uniProtIdentifiers) {
        this.uniProtIdentifiers = uniProtIdentifiers;
    }

    public Optional<Map<String, PfamIdentifier>> getPfamIdentifiers() {
        return Optional.ofNullable(this.pfamIdentifiers);
    }

    void setPfamIdentifiers(Map<String, PfamIdentifier> pfamIdentifiers) {
        this.pfamIdentifiers = pfamIdentifiers;
    }

    public Optional<Map<String, ECNumber>> getEcNumbers() {
        return Optional.ofNullable(this.ecNumbers);
    }

    void setEcNumbers(Map<String, ECNumber> ecNumbers) {
        this.ecNumbers = ecNumbers;
    }

    public String getStructureTitle() {
        return this.structureTitle;
    }

    void setStructureTitle(String structureTitle) {
        this.structureTitle = structureTitle;
    }

    public String toString() {
        return "Fit3DMatch{substructureSuperimposition=" + this.substructureSuperimposition + ", rmsd=" + this.rmsd + ", pvalue=" + this.pvalue + '}';
    }

    public SubstructureSuperimposition getSubstructureSuperimposition() {
        return this.substructureSuperimposition;
    }

    public double getRmsd() {
        return this.rmsd;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public String toCsvLine() {
        StringJoiner stringJoiner = new StringJoiner(",");
        String stringRepresentation = this.substructureSuperimposition.getStringRepresentation();
        stringJoiner.add(stringRepresentation.replaceFirst("\\d+\\.\\d+_", ""));
        stringJoiner.add(String.valueOf(this.rmsd));
        stringJoiner.add(String.valueOf(this.pvalue));
        stringJoiner.add(this.structureTitle != null ? "\"" + this.structureTitle.replaceAll("\"", "") + "\"" : "n/a");
        stringJoiner.add(this.uniProtIdentifiers != null ? (CharSequence)this.uniProtIdentifiers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",", "[", "]")) : "n/a");
        stringJoiner.add(this.pfamIdentifiers != null ? (CharSequence)this.pfamIdentifiers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",", "[", "]")) : "n/a");
        stringJoiner.add(this.ecNumbers != null ? (CharSequence)this.ecNumbers.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",", "[", "]")) : "n/a");
        return stringJoiner.toString();
    }

    @Override
    public int compareTo(Fit3DMatch other) {
        return Double.compare(this.rmsd, other.rmsd);
    }
}

