/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations;

import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepresentationScheme
implements RepresentationScheme {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRepresentationScheme.class);

    Atom determineCentroid(LeafSubstructure<?> leafSubstructure) {
        Optional<Atom> optionalCO = leafSubstructure.getAtomByName("CO");
        if (optionalCO.isPresent()) {
            return optionalCO.get();
        }
        logger.debug("obtaining centroid representation for {}", leafSubstructure);
        return new OakAtom(leafSubstructure.getAllAtoms().get(0).getAtomIdentifier(), ElementProvider.UNKOWN, RepresentationSchemeType.CENTROID.getAtomNameString(), Vectors3D.getCentroid((Collection)leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).map(Atom::getPosition).collect(Collectors.toList())));
    }
}

