/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations;

import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.Optional;

public class AlphaCarbonRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?> leafSubstructure) {
        Optional<Atom> optionalCA = leafSubstructure.getAtomByName("CA");
        if (optionalCA.isPresent()) {
            return optionalCA.get();
        }
        if (!(leafSubstructure instanceof AminoAcid)) {
            logger.warn("fallback for {} because it is no amino acid", leafSubstructure);
            return this.determineCentroid(leafSubstructure);
        }
        return leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isAlphaCarbon()).findAny().orElseGet(() -> this.determineCentroid(leafSubstructure));
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.ALPHA_CARBON;
    }
}

