/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations;

import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BetaCarbonRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?> leafSubstructure) {
        Optional<Atom> optionalBetaCarbon = leafSubstructure.getAtomByName("CB");
        if (optionalBetaCarbon.isPresent()) {
            return optionalBetaCarbon.get();
        }
        if (!(leafSubstructure instanceof AminoAcid)) {
            logger.warn("fallback for {} because it is no amino acid", leafSubstructure);
            return this.determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getFamily() == AminoAcidFamily.GLYCINE) {
            AminoAcid alanine = AminoAcidFamily.ALANINE.getPrototype();
            SubstructureSuperimposition superimposition = SubstructureSuperimposer.calculateIdealSubstructureSuperimposition(Stream.of(leafSubstructure).collect(Collectors.toList()), Stream.of(alanine).collect(Collectors.toList()), StructuralEntityFilter.AtomFilter.isBackbone());
            Optional<Atom> optionalVirtualBetaCarbon = superimposition.getMappedFullCandidate().get(0).getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isBetaCarbon()).findAny();
            if (optionalVirtualBetaCarbon.isPresent()) {
                return new OakAtom(leafSubstructure.getAllAtoms().get(0).getAtomIdentifier(), ElementProvider.CARBON, RepresentationSchemeType.BETA_CARBON.getAtomNameString(), (Vector3D)optionalVirtualBetaCarbon.get().getPosition().getCopy());
            }
        }
        return leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isBetaCarbon()).findAny().orElseGet(() -> this.determineCentroid(leafSubstructure));
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.BETA_CARBON;
    }
}

