/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations;

import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.BetaCarbonRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.elements.ElementProvider;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakAtom;
import de.bioforscher.singa.structure.model.oak.StructuralEntityFilter;
import de.bioforscher.singa.structure.model.oak.Structures;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class LastHeavySidechainRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?> leafSubstructure) {
        Optional<Atom> optionalLH = leafSubstructure.getAtomByName("LH");
        if (optionalLH.isPresent()) {
            return optionalLH.get();
        }
        if (!(leafSubstructure instanceof AminoAcid) || leafSubstructure.getAllAtoms().stream().noneMatch(StructuralEntityFilter.AtomFilter.isAlphaCarbon())) {
            return this.determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getFamily() == AminoAcidFamily.GLYCINE) {
            return new BetaCarbonRepresentationScheme().determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getAllAtoms().stream().noneMatch(StructuralEntityFilter.AtomFilter.isSideChain()) || leafSubstructure.getAllAtoms().stream().noneMatch(StructuralEntityFilter.AtomFilter.isAlphaCarbon())) {
            return this.determineCentroid(leafSubstructure);
        }
        LabeledSymmetricMatrix<Atom> atomDistanceMatrix = Structures.calculateAtomDistanceMatrix(leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isSideChain().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).or(StructuralEntityFilter.AtomFilter.isAlphaCarbon())).collect(Collectors.toList()));
        if (atomDistanceMatrix.getRowDimension() == 1) {
            return (Atom)atomDistanceMatrix.getColumnLabel(0);
        }
        int maximalElementIndex = Vectors.getIndexWithMaximalElement((Vector)atomDistanceMatrix.getRowByLabel((Object)leafSubstructure.getAtomByName("CA").orElseThrow(NoSuchElementException::new)));
        Atom referenceAtom = (Atom)atomDistanceMatrix.getColumnLabel(maximalElementIndex);
        return new OakAtom(leafSubstructure.getAllAtoms().get(leafSubstructure.getAllAtoms().size() - 1).getAtomIdentifier(), ElementProvider.UNKOWN, RepresentationSchemeType.LAST_HEAVY_SIDE_CHAIN.getAtomNameString(), referenceAtom.getPosition());
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.LAST_HEAVY_SIDE_CHAIN;
    }
}

