/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations;

import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.AlphaCarbonRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.BetaCarbonRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.CentroidRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.LastHeavySidechainRepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.SideChainCentroidRepresentationScheme;

public enum RepresentationSchemeType {
    ALPHA_CARBON(AlphaCarbonRepresentationScheme.class, "CA", "alpha carbon"),
    BETA_CARBON(BetaCarbonRepresentationScheme.class, "CB", "beta carbon"),
    CENTROID(CentroidRepresentationScheme.class, "CO", "all-atom centroid"),
    LAST_HEAVY_SIDE_CHAIN(LastHeavySidechainRepresentationScheme.class, "LH", "last heavy side chain atom"),
    SIDE_CHAIN_CENTROID(SideChainCentroidRepresentationScheme.class, "SC", "side chain centroid");

    private final Class<? extends AbstractRepresentationScheme> compatibleRepresentationScheme;
    private final String atomNomenclature;
    private final String description;

    private RepresentationSchemeType(Class<? extends AbstractRepresentationScheme> compatibleRepresentationScheme, String atomNomenclature, String description) {
        this.compatibleRepresentationScheme = compatibleRepresentationScheme;
        this.atomNomenclature = atomNomenclature;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends AbstractRepresentationScheme> getCompatibleRepresentationScheme() {
        return this.compatibleRepresentationScheme;
    }

    public String getAtomNameString() {
        return this.atomNomenclature;
    }
}

