/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics;

import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.Fit3DMatch;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.statistics.StatisticalModel;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.AtomContainer;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarkEstimation
implements StatisticalModel {
    private static final Logger logger = LoggerFactory.getLogger(StarkEstimation.class);
    private static final double A0 = 2.678E9;
    private static final double A2 = 1.277E-7;
    private static final double A3 = 0.00179;
    private static final double C2 = 0.196;
    private static final double C3 = 0.094;
    private static final Map<AminoAcidFamily, Double> AMINOACID_SCORES = new HashMap<AminoAcidFamily, Double>();

    @Override
    public void calculatePvalues(List<Fit3DMatch> matches) {
        for (Fit3DMatch match : matches) {
            int numberOfAtoms;
            double b;
            double a;
            int n = match.getSubstructureSuperimposition().getCandidate().size();
            double c = 1.0;
            double d = 0.0;
            if (n > 2) {
                a = 2.678E9 * Math.pow(0.00179, n);
                b = 2.93 * (double)n - 5.88;
                for (LeafSubstructure<?> leafSubstructure : match.getSubstructureSuperimposition().getCandidate()) {
                    if (!(leafSubstructure instanceof AminoAcid)) {
                        logger.info("ignoring non amino acid when calculating p-value with Stark et al. model");
                        continue;
                    }
                    a *= AMINOACID_SCORES.get(((AminoAcid)leafSubstructure).getFamily()).doubleValue();
                    numberOfAtoms = match.getSubstructureSuperimposition().getMappedCandidate().stream().map(AtomContainer::getAllAtoms).mapToInt(Collection::size).sum();
                    if (numberOfAtoms == 2) {
                        c *= 0.196;
                        d += 2.0;
                        continue;
                    }
                    if (numberOfAtoms <= 2) continue;
                    c *= 0.094;
                    d += 3.0;
                }
            } else {
                a = 341.98060000000004;
                b = 0.97;
                for (LeafSubstructure<?> leafSubstructure : match.getSubstructureSuperimposition().getCandidate()) {
                    if (!(leafSubstructure instanceof AminoAcid)) {
                        logger.info("ignoring non amino acid when calculating p-value with Stark et al. model");
                        continue;
                    }
                    numberOfAtoms = match.getSubstructureSuperimposition().getMappedCandidate().stream().map(AtomContainer::getAllAtoms).mapToInt(Collection::size).sum();
                    if (numberOfAtoms == 2) {
                        c *= 0.196;
                        d += 2.0;
                        continue;
                    }
                    if (numberOfAtoms <= 2) continue;
                    c *= 0.094;
                    d += 3.0;
                }
            }
            if (a * c * Math.pow(match.getRmsd(), b + d) < a * Math.pow(match.getRmsd(), b)) {
                match.setPvalue(1.0 - Math.exp(-(a * c * Math.pow(match.getRmsd(), b + d))));
                continue;
            }
            match.setPvalue(1.0 - Math.exp(-(a * Math.pow(match.getRmsd(), b))));
        }
    }

    static {
        AMINOACID_SCORES.put(AminoAcidFamily.ALANINE, 8.19);
        AMINOACID_SCORES.put(AminoAcidFamily.ARGININE, 4.62);
        AMINOACID_SCORES.put(AminoAcidFamily.ASPARAGINE, 4.66);
        AMINOACID_SCORES.put(AminoAcidFamily.ASPARTIC_ACID, 5.79);
        AMINOACID_SCORES.put(AminoAcidFamily.CYSTEINE, 1.64);
        AMINOACID_SCORES.put(AminoAcidFamily.GLUTAMINE, 3.71);
        AMINOACID_SCORES.put(AminoAcidFamily.GLUTAMIC_ACID, 5.99);
        AMINOACID_SCORES.put(AminoAcidFamily.GLYCINE, 7.96);
        AMINOACID_SCORES.put(AminoAcidFamily.HISTIDINE, 2.33);
        AMINOACID_SCORES.put(AminoAcidFamily.ISOLEUCINE, 5.42);
        AMINOACID_SCORES.put(AminoAcidFamily.LEUCINE, 8.39);
        AMINOACID_SCORES.put(AminoAcidFamily.LYSINE, 6.04);
        AMINOACID_SCORES.put(AminoAcidFamily.METHIONINE, 2.03);
        AMINOACID_SCORES.put(AminoAcidFamily.PHENYLALANINE, 3.98);
        AMINOACID_SCORES.put(AminoAcidFamily.PROLINE, 4.59);
        AMINOACID_SCORES.put(AminoAcidFamily.SERINE, 6.33);
        AMINOACID_SCORES.put(AminoAcidFamily.THREONINE, 6.15);
        AMINOACID_SCORES.put(AminoAcidFamily.TRYPTOPHAN, 1.54);
        AMINOACID_SCORES.put(AminoAcidFamily.TYROSINE, 3.65);
        AMINOACID_SCORES.put(AminoAcidFamily.VALINE, 7.0);
    }
}

