/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.scores;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeFactory;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PsScore {
    private static final List<EnumSet<?>> AMINO_ACID_GROUPS = new ArrayList();
    private final int referenceLength;
    private final int queryLength;
    private final RepresentationScheme alphaCarbonRepresentation;
    private final RepresentationScheme betaCarbonRepresentation;
    private SubstructureSuperimposition substructureSuperimposition;
    private double score;
    private double significance;

    private PsScore(SubstructureSuperimposition substructureSuperimposition, int referenceLength, int queryLength) {
        this.substructureSuperimposition = substructureSuperimposition;
        this.referenceLength = referenceLength;
        this.queryLength = queryLength;
        this.alphaCarbonRepresentation = RepresentationSchemeFactory.createRepresentationScheme(RepresentationSchemeType.ALPHA_CARBON);
        this.betaCarbonRepresentation = RepresentationSchemeFactory.createRepresentationScheme(RepresentationSchemeType.BETA_CARBON);
        this.calculateScore();
        this.calculateSignificance();
    }

    private static boolean belongToSameGroup(Pair<LeafSubstructure<?>> leafSubstructurePair) {
        return AMINO_ACID_GROUPS.stream().anyMatch(group -> group.contains(((LeafSubstructure)leafSubstructurePair.getFirst()).getFamily()) && group.contains(((LeafSubstructure)leafSubstructurePair.getSecond()).getFamily()));
    }

    public static PsScore of(SubstructureSuperimposition substructureSuperimposition, int referenceLength, int queryLength) {
        return new PsScore(substructureSuperimposition, referenceLength, queryLength);
    }

    private void calculateSignificance() {
        this.significance = 1.0 - Math.exp(-Math.exp(-this.calculateZ()));
    }

    private double calculateZ() {
        double mu = 0.3117 + 0.0277 * Math.log(this.queryLength) + -0.029 * Math.log(this.referenceLength);
        double sigma = 0.0366 + 0.0025 * Math.log(this.queryLength) + -0.0084 * Math.log(this.referenceLength);
        return (this.score - mu) / sigma;
    }

    private void calculateScore() {
        double scalingFactor = 0.23 - 12.0 / Math.pow(this.queryLength, 1.88);
        this.score = (this.determineS() + scalingFactor) / (1.0 + scalingFactor);
    }

    private double determineS() {
        double sumValue = 0.0;
        for (int i = 0; i < this.substructureSuperimposition.getReference().size(); ++i) {
            LeafSubstructure<?> referenceLeafSubstructure = this.substructureSuperimposition.getReference().get(i);
            LeafSubstructure<?> queryLeafSubstructure = this.substructureSuperimposition.getMappedCandidate().get(i);
            double distance = VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistance((Vector)referenceLeafSubstructure.getPosition(), (Vector)queryLeafSubstructure.getPosition());
            double distanceScalingFactor = 0.7 * Math.pow(this.queryLength - 5, 0.25) - 0.2;
            double pi = this.calculateP(referenceLeafSubstructure, queryLeafSubstructure);
            double ri = this.calculateR(referenceLeafSubstructure, queryLeafSubstructure);
            sumValue += pi * ri * (1.0 + Math.pow(distance, 2.0) / Math.pow(distanceScalingFactor, 2.0));
        }
        return 1.0 / (double)this.queryLength * sumValue;
    }

    private double calculateR(LeafSubstructure<?> referenceLeafSubstructure, LeafSubstructure<?> querylLeafSubstructure) {
        boolean belongToSameGroup = PsScore.belongToSameGroup(new Pair(referenceLeafSubstructure, querylLeafSubstructure));
        return Math.max(0.8, belongToSameGroup ? 1.0 : 0.0);
    }

    private double calculateP(LeafSubstructure<?> referenceLeafSubstructure, LeafSubstructure<?> querylLeafSubstructure) {
        if (referenceLeafSubstructure.getFamily() != AminoAcidFamily.GLYCINE && querylLeafSubstructure.getFamily() != AminoAcidFamily.GLYCINE) {
            double theta = this.determineAlphaBetaVector(referenceLeafSubstructure).angleTo((Vector)this.determineAlphaBetaVector(querylLeafSubstructure));
            if (theta <= 1.0471975511965976) {
                return 1.0;
            }
            return Math.max(0.1, 0.5 + Math.cos(theta));
        }
        if (referenceLeafSubstructure.getFamily() == AminoAcidFamily.GLYCINE && querylLeafSubstructure.getFamily() != AminoAcidFamily.GLYCINE) {
            return 0.77;
        }
        return 1.0;
    }

    private Vector3D determineAlphaBetaVector(LeafSubstructure<?> leafSubstructure) {
        return this.alphaCarbonRepresentation.determineRepresentingAtom(leafSubstructure).getPosition().subtract(this.betaCarbonRepresentation.determineRepresentingAtom(leafSubstructure).getPosition());
    }

    public double getScore() {
        return this.score;
    }

    public double getSignificance() {
        return this.significance;
    }

    public String toString() {
        return "PsScore{referenceLength=" + this.referenceLength + ", queryLength=" + this.queryLength + ", score=" + this.score + ", significance=" + this.significance + '}';
    }

    static {
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.LEUCINE, AminoAcidFamily.VALINE, AminoAcidFamily.ISOLEUCINE, AminoAcidFamily.METHIONINE, AminoAcidFamily.CYSTEINE));
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.ALANINE, AminoAcidFamily.GLYCINE));
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.SERINE, AminoAcidFamily.THREONINE));
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.PROLINE));
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.PHENYLALANINE, AminoAcidFamily.TYROSINE, AminoAcidFamily.TRYPTOPHAN));
        AMINO_ACID_GROUPS.add(EnumSet.of(AminoAcidFamily.GLUTAMIC_ACID, AminoAcidFamily.ASPARTIC_ACID, AminoAcidFamily.ASPARAGINE, AminoAcidFamily.GLUTAMINE));
    }
}

