/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.scores;

import de.bioforscher.singa.core.utility.Resources;
import de.bioforscher.singa.mathematics.concepts.Subtractable;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.Matrices;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubstitutionMatrix
extends Enum<SubstitutionMatrix> {
    public static final /* enum */ SubstitutionMatrix BLOSUM_45 = new SubstitutionMatrix("de/bioforscher/singa/structure/algorithms/superimposition/scores/blosum45.csv");
    public static final /* enum */ SubstitutionMatrix MC_LACHLAN = new SubstitutionMatrix("de/bioforscher/singa/structure/algorithms/superimposition/scores/mclachlan.csv");
    private LabeledSymmetricMatrix<StructuralFamily> matrix;
    private static final /* synthetic */ SubstitutionMatrix[] $VALUES;

    public static SubstitutionMatrix[] values() {
        return (SubstitutionMatrix[])$VALUES.clone();
    }

    public static SubstitutionMatrix valueOf(String name) {
        return Enum.valueOf(SubstitutionMatrix.class, name);
    }

    private SubstitutionMatrix(String resourceLocation) {
        Logger logger = LoggerFactory.getLogger(SubstitutionMatrix.class);
        InputStream stream = Resources.getResourceAsStream((String)resourceLocation);
        LabeledSymmetricMatrix stringLabeledMatrix = null;
        try {
            stringLabeledMatrix = (LabeledSymmetricMatrix)Matrices.readLabeledMatrixFromCSV((InputStream)stream);
        }
        catch (IOException e) {
            logger.error("failed to read subsitution matrices from resources", (Throwable)e);
        }
        ArrayList<AminoAcidFamily> structuralFamilyLabels = new ArrayList<AminoAcidFamily>();
        assert (stringLabeledMatrix != null);
        for (int i = 0; i < stringLabeledMatrix.getRowDimension(); ++i) {
            String matrixLabel = (String)stringLabeledMatrix.getRowLabel(i);
            if (!Arrays.stream(AminoAcidFamily.values()).map(Enum::name).anyMatch(name -> name.equals(matrixLabel))) continue;
            structuralFamilyLabels.add(AminoAcidFamily.valueOf((String)stringLabeledMatrix.getRowLabel(i)));
        }
        this.matrix = new LabeledSymmetricMatrix(stringLabeledMatrix.getCompleteElements());
        this.matrix.setRowLabels(structuralFamilyLabels);
    }

    public LabeledSymmetricMatrix<StructuralFamily> toCostMatrix() {
        switch (this) {
            case BLOSUM_45: {
                Matrix invertedMatrix = BLOSUM_45.getMatrix().additivelyInvert();
                double minimalElement = Matrices.getPositionOfMinimalElement((Matrix)invertedMatrix).map(position -> invertedMatrix.getElements()[(Integer)position.getFirst()][(Integer)position.getSecond()]).orElse(Double.NaN);
                double[][] matrixWithMinimalElement = new double[invertedMatrix.getRowDimension()][invertedMatrix.getColumnDimension()];
                for (int i = 0; i < matrixWithMinimalElement.length; ++i) {
                    for (int j = 0; j < matrixWithMinimalElement[i].length; ++j) {
                        matrixWithMinimalElement[i][j] = minimalElement;
                    }
                }
                RegularMatrix summand = new RegularMatrix(matrixWithMinimalElement);
                LabeledSymmetricMatrix costMatrix = new LabeledSymmetricMatrix(((Matrix)invertedMatrix.subtract((Subtractable)summand)).getElements());
                costMatrix.setRowLabels(BLOSUM_45.getMatrix().getRowLabels());
                costMatrix.setColumnLabels(BLOSUM_45.getMatrix().getColumnLabels());
                return costMatrix;
            }
            case MC_LACHLAN: {
                return this.getMatrix();
            }
        }
        return this.getMatrix();
    }

    public LabeledSymmetricMatrix<StructuralFamily> getMatrix() {
        return this.matrix;
    }

    static {
        $VALUES = new SubstitutionMatrix[]{BLOSUM_45, MC_LACHLAN};
    }
}

