/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.structure.algorithms.superimposition.scores;

import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.structure.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationScheme;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeFactory;
import de.bioforscher.singa.structure.algorithms.superimposition.fit3d.representations.RepresentationSchemeType;
import de.bioforscher.singa.structure.algorithms.superimposition.scores.SubstitutionMatrix;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;

public class XieScore {
    private final double score;
    private final SubstitutionMatrix substitutionMatrix;
    private final SubstructureSuperimposition substructureSuperimposition;
    private double normalizedScore;
    private double significance;

    private XieScore(SubstitutionMatrix substitutionMatrix, SubstructureSuperimposition substructureSuperimposition) {
        this.substitutionMatrix = substitutionMatrix;
        this.substructureSuperimposition = substructureSuperimposition;
        this.score = this.calculateRawScore(substructureSuperimposition);
        this.normalizeScore();
        this.determineSignificance();
    }

    public static XieScore of(SubstitutionMatrix substitutionMatrix, SubstructureSuperimposition substructureSuperimposition) {
        return new XieScore(substitutionMatrix, substructureSuperimposition);
    }

    public String toString() {
        return "XieScore{score=" + this.score + ", normalizedScore=" + this.normalizedScore + ", significance=" + this.significance + ", substitutionMatrix=" + (Object)((Object)this.substitutionMatrix) + '}';
    }

    private double calculateRawScore(SubstructureSuperimposition substructureSuperimposition) {
        RepresentationScheme xieRepresentationScheme = RepresentationSchemeFactory.createRepresentationScheme(RepresentationSchemeType.ALPHA_CARBON);
        double temporaryScore = 0.0;
        for (int i = 0; i < substructureSuperimposition.getReference().size(); ++i) {
            LeafSubstructure<?> reference = substructureSuperimposition.getReference().get(i);
            LeafSubstructure<?> candidate = substructureSuperimposition.getMappedCandidate().get(i);
            double m = this.substitutionMatrix.getMatrix().getValueFromPosition(this.substitutionMatrix.getMatrix().getPositionFromLabels(reference.getFamily(), candidate.getFamily()));
            double angle = xieRepresentationScheme.determineRepresentingAtom(reference).getPosition().angleTo((Vector)xieRepresentationScheme.determineRepresentingAtom(candidate).getPosition());
            if (Double.isNaN(angle)) {
                angle = 0.0;
            }
            double pa = angle > 1.5707963267948966 ? 0.0 : Math.cos(angle);
            double distance = xieRepresentationScheme.determineRepresentingAtom(reference).getPosition().distanceTo((Vector)xieRepresentationScheme.determineRepresentingAtom(candidate).getPosition());
            double pd = distance > 4.0 ? 0.0 : (distance <= 2.0 ? 1.0 : Math.exp(-(distance - 2.0) * (distance - 2.0) / 2.0));
            temporaryScore += m * pa * pd;
        }
        return temporaryScore;
    }

    private void determineSignificance() {
        double a = Double.NaN;
        double b = Double.NaN;
        double c = Double.NaN;
        double d = Double.NaN;
        double e = Double.NaN;
        double f = Double.NaN;
        if (this.substitutionMatrix == SubstitutionMatrix.BLOSUM_45) {
            a = 17.242;
            b = -40.911;
            c = 46.138;
            d = 5.998;
            e = -12.37;
            f = 25.441;
        } else if (this.substitutionMatrix == SubstitutionMatrix.MC_LACHLAN) {
            a = 5.963;
            b = -15.523;
            c = 21.69;
            d = 3.122;
            e = -9.449;
            f = 18.252;
        }
        int n = this.substructureSuperimposition.getReference().size();
        double mu = a * Math.log(n) * Math.log(n) + b * Math.log(n) + c;
        double sigma = d * Math.log(n) * Math.log(n) + e * Math.log(n) + f;
        double z = (this.score * this.score - mu) / sigma;
        this.significance = 1.0 - Math.exp(-Math.exp(-z));
    }

    private void normalizeScore() {
        double upperBound = this.calculateRawScore(new SubstructureSuperimposition(0.0, null, null, this.substructureSuperimposition.getReference(), null, this.substructureSuperimposition.getReference(), null)) + this.calculateRawScore(new SubstructureSuperimposition(0.0, null, null, this.substructureSuperimposition.getCandidate(), null, this.substructureSuperimposition.getCandidate(), null)) / 2.0;
        this.normalizedScore = 1.0 - this.score / upperBound;
    }

    public double getScore() {
        return this.score;
    }

    public double getSignificance() {
        return this.significance;
    }

    public double getNormalizedScore() {
        return this.normalizedScore;
    }
}

